/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.commands.player;

import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.managers.island.NewIslandLocationStrategy;
import world.bentobox.bentobox.util.Util;
import world.bentobox.stranger.StrangerRealms;

public class ClaimLocationStrategy
implements NewIslandLocationStrategy {
    protected final BentoBox plugin = BentoBox.getInstance();
    private final StrangerRealms addon;

    public ClaimLocationStrategy(StrangerRealms addon) {
        this.addon = addon;
    }

    public Location getNextLocation(World world, User user) {
        if (!Util.getWorld((World)user.getWorld()).equals((Object)world)) {
            user.sendMessage("strangerrealms.errors.not-in-world", new String[0]);
            return null;
        }
        Location location = user.getLocation();
        if (this.plugin.getIslands().isIslandAt(location)) {
            user.sendMessage("strangerrealms.errors.already-claimed", new String[0]);
            return null;
        }
        int dist = this.plugin.getIWM().getIslandDistance(world);
        HashSet<Location> locs = new HashSet<Location>();
        locs.add(location);
        locs.add(new Location(world, location.getX() - (double)dist, 0.0, location.getZ() - (double)dist));
        locs.add(new Location(world, location.getX() - (double)dist, 0.0, location.getZ() + (double)dist - 1.0));
        locs.add(new Location(world, location.getX() + (double)dist - 1.0, 0.0, location.getZ() - (double)dist));
        locs.add(new Location(world, location.getX() + (double)dist - 1.0, 0.0, location.getZ() + (double)dist - 1.0));
        for (Location l : locs) {
            if (this.plugin.getIslands().getIslandAt(l).isPresent()) {
                user.sendMessage("strangerrealms.errors.overlap", new String[]{"[xyz]", Util.xyz((Vector)l.toVector())});
                return null;
            }
            if (this.addon.getSettings().isDisableWorldBorder() || user.getPlayer().getWorldBorder().isInside(l)) continue;
            user.sendMessage("strangerrealms.errors.no-fit-inside", new String[0]);
            return null;
        }
        return user.getLocation();
    }

    public Location getNextLocation(World world) {
        return null;
    }
}

