/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.generator;

import java.util.Random;
import org.bukkit.util.noise.NoiseGenerator;
import org.bukkit.util.noise.SimplexNoiseGenerator;

public class CustomCaveGenerator
extends NoiseGenerator {
    private final NoiseGenerator noiseGen1;
    private final NoiseGenerator noiseGen2;

    public CustomCaveGenerator(long seed) {
        Random rand1 = new Random(seed);
        Random rand2 = new Random(seed * 2L);
        this.noiseGen1 = new SimplexNoiseGenerator(rand1);
        this.noiseGen2 = new SimplexNoiseGenerator(rand2);
    }

    public CustomCaveGenerator(Random rand) {
        this.noiseGen1 = new SimplexNoiseGenerator(new Random(rand.nextLong()));
        this.noiseGen2 = new SimplexNoiseGenerator(new Random(rand.nextLong()));
    }

    public double noise(double x, double y, double z) {
        double frequency = 0.04;
        double cheeseFrequency = 0.08;
        double xf = x * frequency;
        double yf = y * frequency;
        double zf = z * frequency;
        double xc = x * cheeseFrequency;
        double yc = y * cheeseFrequency;
        double zc = z * cheeseFrequency;
        double noiseValue1 = Math.abs(this.noiseGen1.noise(xf, yf, zf));
        double noiseValue2 = Math.abs(this.noiseGen2.noise(xf, yf, zf));
        double cheeseValue = this.noiseGen1.noise(xc, yc / 2.0, zc);
        double finalNoise = Math.max(noiseValue1, noiseValue2);
        double cheeseModifier = (cheeseValue - 0.3) * 0.3;
        if (cheeseModifier > 0.0) {
            finalNoise -= cheeseModifier;
        }
        return finalNoise;
    }
}

