/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.PortalType;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Fence;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.LootTables;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.util.ExpiringSet;
import world.bentobox.bentobox.util.Pair;
import world.bentobox.bentobox.util.Util;
import world.bentobox.stranger.StrangerRealms;
import world.bentobox.stranger.database.NetherChunksMade;

public class NetherChunkMaker
implements Listener {
    private static final int ROOF_HEIGHT = 107;
    private static final int CEILING_START = 100;
    protected static final int NETHER_FLOOR = 20;
    private static final String NETHER_CHUNKS_TABLE = "StrangerChunks";
    private static final Set<Material> NETHER_STRUCTURE_BLOCKS = Set.of(Material.NETHER_BRICKS, Material.NETHER_BRICK_FENCE, Material.NETHER_BRICK_SLAB, Material.NETHER_BRICK_STAIRS, Material.NETHER_BRICK_WALL, Material.CHISELED_NETHER_BRICKS, Material.CRACKED_NETHER_BRICKS, Material.BONE_BLOCK, Material.SPAWNER, Material.CHEST);
    public static final Map<Biome, Biome> BIOME_MAPPING;
    private final StrangerRealms addon;
    private final Random rand = new Random();
    private final Database<NetherChunksMade> handler;
    private final NetherChunksMade netherChunksMade;
    private final int maxChestFills;
    private final ExpiringSet<UUID> portalPlayer = new ExpiringSet(10L, TimeUnit.SECONDS);
    private final TreeMap<Integer, LootTable> chestContents;

    public NetherChunkMaker(StrangerRealms addon) {
        this.addon = addon;
        this.handler = new Database((Addon)addon, NetherChunksMade.class);
        if (this.handler.objectExists(NETHER_CHUNKS_TABLE)) {
            this.netherChunksMade = (NetherChunksMade)this.handler.loadObject(NETHER_CHUNKS_TABLE);
        } else {
            this.netherChunksMade = new NetherChunksMade();
            this.handler.saveObjectAsync((Object)this.netherChunksMade);
        }
        this.maxChestFills = addon.getSettings().getChestFills();
        this.chestContents = new TreeMap();
        this.chestContents.put(1, LootTables.BASTION_TREASURE.getLootTable());
        this.chestContents.put(4, LootTables.NETHER_BRIDGE.getLootTable());
        this.chestContents.put(9, LootTables.GHAST.getLootTable());
        this.chestContents.put(14, LootTables.PIGLIN_BARTERING.getLootTable());
    }

    public void clearDatabase() {
        if (this.handler.objectExists(NETHER_CHUNKS_TABLE)) {
            this.handler.deleteID(NETHER_CHUNKS_TABLE);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onNetherPortalEnter(EntityPortalEnterEvent e) {
        if (e.getPortalType() != PortalType.NETHER || e.getEntityType() != EntityType.PLAYER || !this.addon.inWorld(e.getLocation()) || this.portalPlayer.contains((Object)e.getEntity().getUniqueId())) {
            return;
        }
        Player p = (Player)e.getEntity();
        this.portalPlayer.add((Object)p.getUniqueId());
        if (e.getLocation().getWorld().getEnvironment() == World.Environment.NETHER) {
            return;
        }
        if (StrangerRealms.isWarpedCompass(p.getInventory().getItemInMainHand()) || StrangerRealms.isWarpedCompass(p.getInventory().getItemInOffHand())) {
            this.refreshNetherChunks(p);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onNetherEnterViaTeleport(PlayerChangedWorldEvent e) {
        if (this.addon.inWorld(e.getPlayer().getWorld()) && e.getPlayer().getWorld().getEnvironment() == World.Environment.NETHER) {
            User.getInstance((Player)e.getPlayer()).notify(this.addon.getNetherWorld(), "strangerrealms.nether.welcome", new String[0]);
        }
    }

    private void refreshNetherChunks(Player p) {
        int chunkRadius = Bukkit.getViewDistance();
        int x = p.getLocation().getChunk().getX();
        int z = p.getLocation().getChunk().getZ();
        for (int i = x - chunkRadius; i < x + chunkRadius; ++i) {
            for (int j = z - chunkRadius; j < z + chunkRadius; ++j) {
                this.netherChunksMade.getChunkSet().remove(Pair.of((Object)i, (Object)j));
            }
        }
        this.handler.saveObject((Object)this.netherChunksMade);
        User.getInstance((Player)p).sendMessage("strangerrealms.nether.refresh", new String[0]);
        Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> p.playSound((Entity)p, Sound.ENTITY_LIGHTNING_BOLT_IMPACT, 1.0f, 1.0f));
        this.reduceWarpedCompassAmount(p);
    }

    private void reduceWarpedCompassAmount(Player p) {
        ItemStack mainHandItem = p.getInventory().getItemInMainHand();
        if (StrangerRealms.isWarpedCompass(mainHandItem)) {
            mainHandItem.subtract(1);
            return;
        }
        ItemStack offHandItem = p.getInventory().getItemInOffHand();
        if (StrangerRealms.isWarpedCompass(offHandItem)) {
            offHandItem.subtract(1);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent e) {
        if (!this.isValidChunkLoadEvent(e)) {
            return;
        }
        if (!this.netherChunksMade.getChunkSet().add((Pair<Integer, Integer>)Pair.of((Object)e.getChunk().getX(), (Object)e.getChunk().getZ()))) {
            return;
        }
        this.handler.saveObjectAsync((Object)this.netherChunksMade);
        Chunk chunk = e.getChunk();
        this.clearTileEntities(chunk);
        this.clearEntities(chunk);
        Util.getChunkAtAsync((World)this.addon.getOverWorld(), (int)chunk.getX(), (int)chunk.getZ()).thenRun(() -> {
            this.convertBlocks(chunk);
            this.spawnNetherEntities(chunk);
        });
    }

    private boolean isValidChunkLoadEvent(ChunkLoadEvent e) {
        return e.getWorld().getEnvironment() == World.Environment.NETHER && this.addon.getSettings().isUseUpsideDown() && this.addon.inWorld(e.getWorld());
    }

    private void clearTileEntities(Chunk chunk) {
        Arrays.stream(chunk.getTileEntities()).filter(en -> en.getLocation().getBlockY() < 107 && en instanceof InventoryHolder).forEach(tileEntity -> ((InventoryHolder)tileEntity).getInventory().clear());
    }

    private void clearEntities(Chunk chunk) {
        Arrays.stream(chunk.getEntities()).filter(en -> en.getType() != EntityType.PLAYER && en.getLocation().getBlockY() < 107).forEach(Entity::remove);
    }

    private void convertBlocks(Chunk chunk) {
        Chunk overworldChunk = this.addon.getOverWorld().getChunkAt(chunk.getX(), chunk.getZ());
        int rawAttritionValue = this.addon.getSettings().getAttrition();
        double attrition = rawAttritionValue >= 0 && rawAttritionValue <= 100 ? (double)rawAttritionValue / 100.0 : 0.05;
        int chestFills = 0;
        ArrayList<BoundingBox> structures = new ArrayList<BoundingBox>();
        chunk.getStructures().forEach(gs -> structures.add(gs.getBoundingBox()));
        for (int y = chunk.getWorld().getMinHeight() + 20; y < 107; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockState state;
                    BlockState newSlab;
                    Optional<BlockData> opBlockData;
                    if (y == chunk.getWorld().getMinHeight() + 20) {
                        for (int bleed = y - this.rand.nextInt(5); bleed < y; ++bleed) {
                            chunk.getBlock(x, bleed, z).setType(Material.NETHERRACK, false);
                        }
                    }
                    Block overworldBlock = overworldChunk.getBlock(x, y, z);
                    Block newBlock = chunk.getBlock(x, y, z);
                    newBlock.setBiome(BIOME_MAPPING.getOrDefault(overworldBlock.getBiome(), Biome.NETHER_WASTES));
                    if (overworldBlock.getType() == newBlock.getType() || newBlock.getType() == Material.NETHER_PORTAL || y > 100 && this.rand.nextDouble() < attrition || this.inStructure(chunk.getX(), chunk.getZ(), x, y, z, structures) && NETHER_STRUCTURE_BLOCKS.contains(newBlock.getType())) continue;
                    BlockData overworldBlockData = overworldBlock.getBlockData();
                    Material material = overworldBlockData.getMaterial();
                    BlockData newBlockData = overworldBlockData.clone();
                    if (newBlockData instanceof Waterlogged) {
                        Waterlogged waterlogged = (Waterlogged)newBlockData;
                        waterlogged.setWaterlogged(false);
                    }
                    if ((opBlockData = this.tagCheck(material, newBlockData, attrition, newBlock)).isPresent()) {
                        newBlockData = opBlockData.get();
                    } else {
                        switch (material) {
                            case AIR: {
                                break;
                            }
                            case BELL: 
                            case ENCHANTING_TABLE: 
                            case LECTERN: {
                                newBlockData = Material.SPAWNER.createBlockData();
                                break;
                            }
                            case GRASS_BLOCK: {
                                if (newBlock.getBiome() == Biome.WARPED_FOREST) {
                                    newBlockData = Material.WARPED_NYLIUM.createBlockData();
                                    break;
                                }
                                if (newBlock.getBiome() == Biome.CRIMSON_FOREST) {
                                    newBlockData = Material.CRIMSON_NYLIUM.createBlockData();
                                    break;
                                }
                                if (newBlock.getBiome() == Biome.SOUL_SAND_VALLEY) {
                                    newBlockData = this.rand.nextDouble() < 0.2 ? Material.SOUL_SOIL.createBlockData() : Material.SOUL_SAND.createBlockData();
                                    break;
                                }
                                newBlockData = this.rand.nextDouble() < 0.2 ? Material.SOUL_SOIL.createBlockData() : Material.NETHERRACK.createBlockData();
                                break;
                            }
                            case NETHER_PORTAL: {
                                if (chunk.getBlock(x, y, z).getType() == Material.NETHER_PORTAL) {
                                    newBlockData = Material.NETHER_PORTAL.createBlockData();
                                    break;
                                }
                                newBlockData = Material.AIR.createBlockData();
                                break;
                            }
                            case OBSIDIAN: {
                                newBlockData = Material.AIR.createBlockData();
                                break;
                            }
                            case HAY_BLOCK: {
                                if (newBlock.getBiome() == Biome.DEEP_DARK) {
                                    newBlockData = Material.AIR.createBlockData();
                                    break;
                                }
                                if (newBlock.getBiome() == Biome.CRIMSON_FOREST || newBlock.getBiome() == Biome.WARPED_FOREST) {
                                    newBlockData = Material.SHROOMLIGHT.createBlockData();
                                    break;
                                }
                                newBlockData = Material.GLOWSTONE.createBlockData();
                                break;
                            }
                            case GRAVEL: 
                            case RED_MUSHROOM: 
                            case BROWN_MUSHROOM: {
                                break;
                            }
                            case ANDESITE: {
                                newBlockData = Material.SOUL_SOIL.createBlockData();
                                break;
                            }
                            case DIORITE: 
                            case GRANITE: 
                            case COBBLESTONE: {
                                newBlockData = Material.BASALT.createBlockData();
                                break;
                            }
                            case STONE: 
                            case BUBBLE_COLUMN: {
                                newBlockData = Material.NETHERRACK.createBlockData();
                                break;
                            }
                            case KELP: 
                            case SEAGRASS: {
                                newBlockData = Material.MAGMA_BLOCK.createBlockData();
                                break;
                            }
                            case WATER: {
                                if (newBlock.getBiome() == Biome.DEEP_DARK) {
                                    newBlockData = Material.AIR.createBlockData();
                                    break;
                                }
                                newBlockData = Material.LAVA.createBlockData();
                                break;
                            }
                            case LAVA: {
                                break;
                            }
                            case TORCH: 
                            case WALL_TORCH: {
                                newBlockData = Material.SOUL_TORCH.createBlockData();
                                break;
                            }
                            case TALL_GRASS: {
                                newBlockData = Material.AIR.createBlockData();
                                break;
                            }
                            case SHORT_GRASS: {
                                if (newBlock.getBiome() == Biome.WARPED_FOREST) {
                                    newBlockData = Material.NETHER_SPROUTS.createBlockData();
                                    break;
                                }
                            }
                            case SHORT_DRY_GRASS: {
                                if (this.rand.nextDouble() < attrition) {
                                    newBlockData = Material.FIRE.createBlockData();
                                    break;
                                }
                                newBlockData = Material.AIR.createBlockData();
                                break;
                            }
                            case GLASS: 
                            case GLASS_PANE: {
                                newBlockData = Material.BLACK_STAINED_GLASS_PANE.createBlockData();
                                break;
                            }
                            case BEDROCK: {
                                break;
                            }
                            case BRICKS: {
                                newBlockData = Material.NETHER_BRICK.createBlockData();
                                break;
                            }
                            case CHEST: {
                                break;
                            }
                            case SPAWNER: {
                                break;
                            }
                            case VINE: 
                            case CAVE_VINES: {
                                if (newBlock.getBiome() == Biome.WARPED_FOREST) {
                                    newBlockData = Material.WEEPING_VINES.createBlockData();
                                    break;
                                }
                                newBlockData = Material.TWISTING_VINES.createBlockData();
                                break;
                            }
                            case REDSTONE_WIRE: 
                            case REDSTONE_TORCH: 
                            case REDSTONE_LAMP: 
                            case REDSTONE_WALL_TORCH: 
                            case COMPARATOR: 
                            case LEVER: 
                            case RAIL: 
                            case POWERED_RAIL: {
                                if (!(this.rand.nextDouble() < attrition)) break;
                                newBlockData = Material.FIRE.createBlockData();
                                break;
                            }
                            case CALCITE: 
                            case SMOOTH_BASALT: 
                            case AMETHYST_CLUSTER: 
                            case LARGE_AMETHYST_BUD: 
                            case MEDIUM_AMETHYST_BUD: 
                            case SMALL_AMETHYST_BUD: 
                            case AMETHYST_BLOCK: 
                            case BUDDING_AMETHYST: 
                            case INFESTED_COBBLESTONE: 
                            case INFESTED_CRACKED_STONE_BRICKS: 
                            case END_PORTAL_FRAME: 
                            case GRAY_WOOL: 
                            case SOUL_FIRE: 
                            case SOUL_SAND: 
                            case REDSTONE_BLOCK: 
                            case TARGET: 
                            case SOUL_LANTERN: 
                            case CANDLE: 
                            case SCULK: 
                            case SCULK_VEIN: 
                            case SCULK_SENSOR: 
                            case SCULK_CATALYST: 
                            case SCULK_SHRIEKER: {
                                break;
                            }
                            default: {
                                newBlockData = Material.BLACKSTONE.createBlockData();
                            }
                        }
                    }
                    newBlock.setBlockData(newBlockData, false);
                    if (overworldBlockData instanceof Fence) {
                        Fence fence = (Fence)overworldBlockData;
                        if (newBlockData instanceof Fence) {
                            Fence newFence = (Fence)newBlockData;
                            fence.getFaces().forEach(bf -> newFence.setFace(bf, true));
                        }
                    }
                    if (overworldBlockData instanceof Stairs) {
                        Stairs stairs = (Stairs)overworldBlockData;
                        if (newBlockData instanceof Stairs) {
                            Stairs newStairs = (Stairs)newBlockData;
                            newStairs.setFacing(stairs.getFacing());
                        }
                    }
                    if (overworldBlockData instanceof Slab) {
                        Slab slab = (Slab)overworldBlockData;
                        if (newBlockData instanceof Slab) {
                            newSlab = (Slab)newBlockData;
                            newSlab.setType(slab.getType());
                        }
                    }
                    if ((newSlab = newBlock.getState()) instanceof org.bukkit.block.Chest) {
                        org.bukkit.block.Chest chest = (org.bukkit.block.Chest)newSlab;
                        if (this.maxChestFills < 0 || chestFills < this.maxChestFills) {
                            ++chestFills;
                            this.populateChest(overworldBlock, overworldBlockData, chest, newBlockData);
                        }
                    }
                    newBlock.setBlockData(newBlockData, false);
                    if (newBlock.getType() != Material.SPAWNER || !((state = newBlock.getState()) instanceof CreatureSpawner)) continue;
                    CreatureSpawner spawner = (CreatureSpawner)state;
                    spawner.setSpawnedType(EntityType.BLAZE);
                    spawner.setDelay(-1);
                    spawner.update(true);
                }
            }
        }
    }

    private Optional<BlockData> tagCheck(Material material, BlockData newBlockData, double attrition, Block newBlock) {
        if (Tag.BUTTONS.isTagged((Keyed)material)) {
            newBlockData = this.rand.nextBoolean() ? Material.AIR.createBlockData() : Material.STONE_BUTTON.createBlockData();
        } else if (Tag.DOORS.isTagged((Keyed)material) || Tag.FENCE_GATES.isTagged((Keyed)material)) {
            newBlockData = Material.AIR.createBlockData();
        } else if (Tag.CORAL_BLOCKS.isTagged((Keyed)material)) {
            newBlockData = Material.NETHERRACK.createBlockData();
        } else if (Tag.LOGS.isTagged((Keyed)material)) {
            if (newBlock.getBiome() == Biome.CRIMSON_FOREST) {
                newBlockData = Material.CRIMSON_STEM.createBlockData();
            } else {
                newBlockData = Material.WARPED_STEM.createBlockData();
                newBlock.setBiome(Biome.WARPED_FOREST);
            }
        } else if (Tag.LEAVES.isTagged((Keyed)material)) {
            newBlockData = newBlock.getBiome() == Biome.CRIMSON_FOREST ? Material.WARPED_WART_BLOCK.createBlockData() : Material.NETHER_WART_BLOCK.createBlockData();
        } else if (Tag.STONE_BRICKS.isTagged((Keyed)material)) {
            newBlockData = this.rand.nextBoolean() ? Material.AIR.createBlockData() : Material.NETHER_BRICKS.createBlockData();
        } else if (Tag.SAND.isTagged((Keyed)material)) {
            newBlockData = Material.SOUL_SAND.createBlockData();
            newBlock.setBiome(Biome.SOUL_SAND_VALLEY);
        } else if (Tag.DIRT.isTagged((Keyed)material)) {
            newBlockData = Material.NETHERRACK.createBlockData();
        } else if (Tag.FLOWERS.isTagged((Keyed)material) || Tag.SAPLINGS.isTagged((Keyed)material)) {
            newBlockData = newBlock.getBiome() == Biome.CRIMSON_FOREST ? (this.rand.nextDouble() < 0.2 ? Material.CRIMSON_FUNGUS.createBlockData() : Material.CRIMSON_ROOTS.createBlockData()) : (newBlock.getBiome() == Biome.WARPED_FOREST ? (this.rand.nextDouble() < 0.2 ? Material.WARPED_FUNGUS.createBlockData() : Material.WARPED_ROOTS.createBlockData()) : (this.rand.nextBoolean() ? Material.RED_MUSHROOM.createBlockData() : Material.BROWN_MUSHROOM.createBlockData()));
        } else if (Tag.COAL_ORES.isTagged((Keyed)material) || Tag.IRON_ORES.isTagged((Keyed)material) || Tag.GOLD_ORES.isTagged((Keyed)material)) {
            newBlockData = Material.NETHER_GOLD_ORE.createBlockData();
        } else if (Tag.CROPS.isTagged((Keyed)material)) {
            newBlockData = Material.NETHER_WART.createBlockData();
            newBlock.getRelative(BlockFace.DOWN).setType(Material.SOUL_SAND);
        } else if (Tag.BANNERS.isTagged((Keyed)material)) {
            newBlockData = Material.BLACK_BANNER.createBlockData();
        } else if (Tag.TRAPDOORS.isTagged((Keyed)material)) {
            newBlockData = Material.WARPED_TRAPDOOR.createBlockData();
        } else if (Tag.BADLANDS_TERRACOTTA.isTagged((Keyed)material)) {
            newBlockData = Material.NETHER_BRICKS.createBlockData();
        } else if (Tag.ALL_HANGING_SIGNS.isTagged((Keyed)material)) {
            newBlockData = Material.WARPED_HANGING_SIGN.createBlockData();
        } else if (Tag.ALL_SIGNS.isTagged((Keyed)material)) {
            newBlockData = Material.WARPED_SIGN.createBlockData();
        } else if (Tag.ANVIL.isTagged((Keyed)material)) {
            newBlockData = Material.CRACKED_POLISHED_BLACKSTONE_BRICKS.createBlockData();
        } else if (Tag.CAMPFIRES.isTagged((Keyed)material)) {
            newBlockData = Material.SOUL_CAMPFIRE.createBlockData();
        } else if (Tag.CANDLE_CAKES.isTagged((Keyed)material)) {
            newBlockData = Material.WARPED_HYPHAE.createBlockData();
        } else if (Tag.COAL_ORES.isTagged((Keyed)material)) {
            newBlockData = Material.NETHER_QUARTZ_ORE.createBlockData();
        } else if (Tag.COPPER_ORES.isTagged((Keyed)material)) {
            newBlockData = Material.NETHER_QUARTZ_ORE.createBlockData();
        } else if (Tag.DIAMOND_ORES.isTagged((Keyed)material)) {
            newBlockData = Material.ANCIENT_DEBRIS.createBlockData();
        } else if (Tag.EMERALD_ORES.isTagged((Keyed)material)) {
            newBlockData = Material.NETHER_GOLD_ORE.createBlockData();
        } else if (Tag.GOLD_ORES.isTagged((Keyed)material)) {
            newBlockData = Material.NETHER_GOLD_ORE.createBlockData();
        } else if (Tag.IRON_ORES.isTagged((Keyed)material)) {
            newBlockData = Material.NETHER_GOLD_ORE.createBlockData();
        } else if (Tag.LAPIS_ORES.isTagged((Keyed)material)) {
            newBlockData = Material.NETHER_GOLD_ORE.createBlockData();
        } else if (Tag.REDSTONE_ORES.isTagged((Keyed)material)) {
            newBlockData = Material.NETHER_QUARTZ_ORE.createBlockData();
        } else if (Tag.BEDS.isTagged((Keyed)material)) {
            newBlockData = Material.GLOWSTONE.createBlockData();
        } else if (Tag.BEEHIVES.isTagged((Keyed)material)) {
            newBlockData = Material.GLOWSTONE.createBlockData();
        } else if (Tag.BARS.isTagged((Keyed)material)) {
            newBlockData = Material.IRON_BARS.createBlockData();
        } else if (Tag.CAVE_VINES.isTagged((Keyed)material)) {
            newBlockData = Material.GLOWSTONE.createBlockData();
        } else if (Tag.CAULDRONS.isTagged((Keyed)material)) {
            newBlockData = this.rand.nextBoolean() ? (this.rand.nextDouble() < attrition ? Material.AIR.createBlockData() : Material.CAULDRON.createBlockData()) : (this.rand.nextDouble() < attrition ? Material.AIR.createBlockData() : Material.LAVA_CAULDRON.createBlockData());
        } else if (Tag.COPPER_CHESTS.isTagged((Keyed)material)) {
            newBlockData = this.rand.nextDouble() < attrition ? Material.AIR.createBlockData() : Material.OXIDIZED_COPPER_CHEST.createBlockData();
        } else if (Tag.FENCES.isTagged((Keyed)material)) {
            newBlockData = this.rand.nextDouble() < attrition ? Material.AIR.createBlockData() : Material.NETHER_BRICK_FENCE.createBlockData();
        } else if (Tag.SLABS.isTagged((Keyed)material)) {
            newBlockData = this.rand.nextDouble() < attrition ? Material.AIR.createBlockData() : Material.NETHER_BRICK_SLAB.createBlockData();
        } else if (Tag.STAIRS.isTagged((Keyed)material)) {
            newBlockData = this.rand.nextDouble() < attrition ? Material.AIR.createBlockData() : Material.NETHER_BRICK_STAIRS.createBlockData();
        } else if (Tag.WALLS.isTagged((Keyed)material)) {
            newBlockData = this.rand.nextDouble() < 0.1 ? Material.AIR.createBlockData() : Material.NETHER_BRICK_WALL.createBlockData();
        } else if (newBlock.getType() == Material.OBSIDIAN) {
            newBlockData = Material.OBSIDIAN.createBlockData();
        } else {
            return Optional.empty();
        }
        return Optional.of(newBlockData);
    }

    private boolean inStructure(int chunkX, int chunkZ, int x, int y, int z, List<BoundingBox> structures) {
        double worldX = chunkX * 16 + x;
        double worldY = y;
        double worldZ = chunkZ * 16 + z;
        for (BoundingBox box : structures) {
            if (!box.contains(worldX, worldY, worldZ)) continue;
            return true;
        }
        return false;
    }

    private void populateChest(Block overworldBlock, BlockData bd, org.bukkit.block.Chest chest, BlockData newBlockData) {
        org.bukkit.block.Chest oldChest;
        Location chestLocation = chest.getLocation();
        BlockState blockState = overworldBlock.getState();
        if (blockState instanceof org.bukkit.block.Chest && (oldChest = (org.bukkit.block.Chest)blockState).getLootTable() != null) {
            chest.setLootTable(oldChest.getLootTable());
        } else {
            int totalWeight = this.chestContents.lastKey();
            int randomValue = this.rand.nextInt(totalWeight);
            chest.setLootTable(this.chestContents.higherEntry(randomValue).getValue());
        }
        chest.getInventory().clear();
        chest.setSeed(System.currentTimeMillis() + (long)chestLocation.hashCode());
        if (bd instanceof Chest) {
            Chest chestData = (Chest)bd;
            if (newBlockData instanceof Chest) {
                Chest newChest = (Chest)newBlockData;
                newChest.setFacing(chestData.getFacing());
            }
        }
        chest.update(true);
    }

    private void spawnNetherEntities(Chunk chunk) {
        Arrays.stream(chunk.getEntities()).filter(en -> en instanceof LivingEntity).forEach(en -> {
            EntityType newType = this.getNetherEnt(en.getType());
            if (newType != null) {
                this.addon.getNetherWorld().spawnEntity(en.getLocation().toVector().toLocation(this.addon.getNetherWorld()), newType, true);
            }
        });
    }

    private EntityType getNetherEnt(EntityType type) {
        return switch (type) {
            case EntityType.ALLAY -> EntityType.GHAST;
            case EntityType.ARMADILLO -> EntityType.MAGMA_CUBE;
            case EntityType.AXOLOTL -> EntityType.BLAZE;
            case EntityType.BAT -> EntityType.GHAST;
            case EntityType.BEE -> EntityType.MAGMA_CUBE;
            case EntityType.BLAZE -> EntityType.BLAZE;
            case EntityType.BOGGED -> EntityType.WITHER_SKELETON;
            case EntityType.BREEZE -> EntityType.BLAZE;
            case EntityType.CAMEL -> EntityType.STRIDER;
            case EntityType.CAT -> EntityType.HOGLIN;
            case EntityType.CAVE_SPIDER -> EntityType.CAVE_SPIDER;
            case EntityType.CHICKEN -> EntityType.ZOMBIFIED_PIGLIN;
            case EntityType.COD -> EntityType.GHAST;
            case EntityType.COPPER_GOLEM -> EntityType.COPPER_GOLEM;
            case EntityType.COW -> EntityType.HOGLIN;
            case EntityType.CREEPER -> EntityType.GHAST;
            case EntityType.DONKEY -> EntityType.STRIDER;
            case EntityType.ENDERMAN -> EntityType.ENDERMAN;
            case EntityType.ENDERMITE -> EntityType.MAGMA_CUBE;
            case EntityType.EVOKER -> EntityType.PIGLIN_BRUTE;
            case EntityType.FOX -> EntityType.PIGLIN;
            case EntityType.FROG -> EntityType.MAGMA_CUBE;
            case EntityType.GHAST -> EntityType.GHAST;
            case EntityType.GLOW_SQUID -> EntityType.MAGMA_CUBE;
            case EntityType.GOAT -> EntityType.MAGMA_CUBE;
            case EntityType.HOGLIN -> EntityType.HOGLIN;
            case EntityType.HORSE -> EntityType.STRIDER;
            case EntityType.HUSK -> EntityType.ZOMBIFIED_PIGLIN;
            case EntityType.ILLUSIONER -> EntityType.PIGLIN;
            case EntityType.IRON_GOLEM -> EntityType.WITHER_SKELETON;
            case EntityType.LLAMA -> EntityType.STRIDER;
            case EntityType.MAGMA_CUBE -> EntityType.MAGMA_CUBE;
            case EntityType.MOOSHROOM -> EntityType.HOGLIN;
            case EntityType.MULE -> EntityType.STRIDER;
            case EntityType.OCELOT -> EntityType.PIGLIN;
            case EntityType.PANDA -> EntityType.PIGLIN_BRUTE;
            case EntityType.PARROT -> EntityType.GHAST;
            case EntityType.PHANTOM -> EntityType.GHAST;
            case EntityType.PIG -> EntityType.ZOMBIFIED_PIGLIN;
            case EntityType.PIGLIN -> EntityType.PIGLIN;
            case EntityType.PIGLIN_BRUTE -> EntityType.PIGLIN_BRUTE;
            case EntityType.PILLAGER -> EntityType.PIGLIN;
            case EntityType.POLAR_BEAR -> EntityType.HOGLIN;
            case EntityType.PUFFERFISH -> EntityType.MAGMA_CUBE;
            case EntityType.RABBIT -> EntityType.ZOMBIFIED_PIGLIN;
            case EntityType.RAVAGER -> EntityType.HOGLIN;
            case EntityType.SHEEP -> EntityType.ZOMBIFIED_PIGLIN;
            case EntityType.SHULKER -> EntityType.WITHER_SKELETON;
            case EntityType.SILVERFISH -> EntityType.MAGMA_CUBE;
            case EntityType.SKELETON -> EntityType.WITHER_SKELETON;
            case EntityType.SKELETON_HORSE -> EntityType.STRIDER;
            case EntityType.SLIME -> EntityType.MAGMA_CUBE;
            case EntityType.SNIFFER -> EntityType.PIGLIN_BRUTE;
            case EntityType.SNOW_GOLEM -> EntityType.BLAZE;
            case EntityType.SPIDER -> EntityType.CAVE_SPIDER;
            case EntityType.SQUID -> EntityType.BLAZE;
            case EntityType.STRAY -> EntityType.WITHER_SKELETON;
            case EntityType.STRIDER -> EntityType.STRIDER;
            case EntityType.TURTLE -> EntityType.HOGLIN;
            case EntityType.VEX -> EntityType.BLAZE;
            case EntityType.VILLAGER -> EntityType.PIGLIN;
            case EntityType.VINDICATOR -> EntityType.PIGLIN_BRUTE;
            case EntityType.WANDERING_TRADER -> EntityType.PIGLIN;
            case EntityType.WARDEN -> EntityType.WITHER;
            case EntityType.WITCH -> EntityType.BLAZE;
            case EntityType.WITHER -> EntityType.WITHER;
            case EntityType.WITHER_SKELETON -> EntityType.WITHER_SKELETON;
            case EntityType.WOLF -> EntityType.HOGLIN;
            case EntityType.ZOGLIN -> EntityType.ZOGLIN;
            case EntityType.ZOMBIE -> EntityType.ZOMBIFIED_PIGLIN;
            case EntityType.ZOMBIE_HORSE -> EntityType.STRIDER;
            case EntityType.ZOMBIE_VILLAGER -> EntityType.ZOMBIFIED_PIGLIN;
            case EntityType.ZOMBIFIED_PIGLIN -> EntityType.ZOMBIFIED_PIGLIN;
            case EntityType.HAPPY_GHAST -> EntityType.HAPPY_GHAST;
            case EntityType.MINECART -> EntityType.MINECART;
            default -> null;
        };
    }

    static {
        HashMap<Biome, Biome> biomeMap = new HashMap<Biome, Biome>();
        biomeMap.put(Biome.SWAMP, Biome.CRIMSON_FOREST);
        biomeMap.put(Biome.MANGROVE_SWAMP, Biome.CRIMSON_FOREST);
        biomeMap.put(Biome.JUNGLE, Biome.CRIMSON_FOREST);
        biomeMap.put(Biome.BAMBOO_JUNGLE, Biome.CRIMSON_FOREST);
        biomeMap.put(Biome.DARK_FOREST, Biome.CRIMSON_FOREST);
        biomeMap.put(Biome.DESERT, Biome.BASALT_DELTAS);
        biomeMap.put(Biome.SAVANNA_PLATEAU, Biome.BASALT_DELTAS);
        biomeMap.put(Biome.BADLANDS, Biome.BASALT_DELTAS);
        biomeMap.put(Biome.JAGGED_PEAKS, Biome.BASALT_DELTAS);
        biomeMap.put(Biome.STONY_PEAKS, Biome.BASALT_DELTAS);
        biomeMap.put(Biome.SNOWY_PLAINS, Biome.SOUL_SAND_VALLEY);
        biomeMap.put(Biome.TAIGA, Biome.SOUL_SAND_VALLEY);
        biomeMap.put(Biome.ICE_SPIKES, Biome.SOUL_SAND_VALLEY);
        biomeMap.put(Biome.GROVE, Biome.SOUL_SAND_VALLEY);
        biomeMap.put(Biome.MUSHROOM_FIELDS, Biome.WARPED_FOREST);
        biomeMap.put(Biome.CHERRY_GROVE, Biome.WARPED_FOREST);
        biomeMap.put(Biome.DEEP_DARK, Biome.DEEP_DARK);
        BIOME_MAPPING = Collections.unmodifiableMap(biomeMap);
    }
}

