/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.listeners;

import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import world.bentobox.bentobox.api.events.team.TeamJoinedEvent;
import world.bentobox.bentobox.api.events.team.TeamKickEvent;
import world.bentobox.bentobox.api.events.team.TeamLeaveEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.stranger.StrangerRealms;

public class TeamListener
implements Listener {
    private final StrangerRealms addon;

    public TeamListener(StrangerRealms addon) {
        this.addon = addon;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (!this.addon.inWorld(player.getWorld())) {
            return;
        }
        this.addon.getIslands().getIslands(player.getWorld(), player.getUniqueId()).forEach(this::resize);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        Player player = e.getPlayer();
        if (!this.addon.inWorld(e.getTo())) {
            return;
        }
        this.addon.getIslands().getIslands(e.getTo().getWorld(), player.getUniqueId()).forEach(this::resize);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onTeamJoin(TeamJoinedEvent e) {
        if (!this.addon.inWorld(e.getIsland().getWorld()) || e.getIsland().getMemberSet().size() == 1 || this.addon.getSettings().getMemberBonus() == 0) {
            return;
        }
        int change = this.resize(e.getIsland());
        if (change == 0 && e.getIsland().getOwner() != null) {
            User.getInstance((UUID)e.getIsland().getOwner()).sendMessage("strangerrealms.claim.team-no-change", new String[0]);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onTeamKick(TeamKickEvent e) {
        if (!this.addon.inWorld(e.getIsland().getWorld()) || this.addon.getSettings().getMemberBonus() != 0) {
            this.resize(e.getIsland());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onTeamLeave(TeamLeaveEvent e) {
        if (!this.addon.inWorld(e.getIsland().getWorld()) || this.addon.getSettings().getMemberBonus() != 0) {
            this.resize(e.getIsland());
        }
    }

    protected int resize(Island claim) {
        String suffix;
        this.addon.getPlugin().getIslands().getIslandCache().getIslandGrid(claim.getWorld()).removeFromGrid(claim);
        int size = this.addon.getSettings().getIslandDistance() + this.addon.getSettings().getMemberBonus() * (claim.getMemberSet().size() - 1);
        int oldSize = claim.getProtectionRange();
        claim.setRange(size);
        while (!this.addon.getPlugin().getIslands().getIslandCache().getIslandGrid(claim.getWorld()).addToGrid(claim) && size > oldSize) {
            claim.setRange(--size);
        }
        claim.setProtectionRange(size);
        if (size == oldSize) {
            return 0;
        }
        String string = suffix = size > oldSize ? "increase" : "decrease";
        if (claim.isOwned()) {
            User.getInstance((UUID)claim.getOwner()).sendMessage("strangerrealms.claim.team-" + suffix + "-owner", new String[0]);
        }
        claim.getPlayersOnIsland().stream().filter(p -> claim.getOwner() == null || !p.getUniqueId().equals(claim.getOwner())).map(User::getInstance).forEach(u -> u.sendMessage("strangerrealms.claim.team-" + suffix, new String[0]));
        return size - oldSize;
    }
}

