/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.core;

import com.lx862.mtrscripting.ScriptManager;
import com.lx862.mtrscripting.core.ScriptInstance;
import com.lx862.mtrscripting.data.ScriptContent;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Function;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ImporterTopLevel;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeJavaClass;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeJavaMethod;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeJavaObject;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import com.lx862.mtrscripting.util.CycleTracker;
import com.lx862.mtrscripting.util.FilesUtil;
import com.lx862.mtrscripting.util.GraphicsTexture;
import com.lx862.mtrscripting.util.Matrices;
import com.lx862.mtrscripting.util.NetworkingUtil;
import com.lx862.mtrscripting.util.RateLimit;
import com.lx862.mtrscripting.util.ScriptResourceUtil;
import com.lx862.mtrscripting.util.ScriptVector3f;
import com.lx862.mtrscripting.util.StateTracker;
import com.lx862.mtrscripting.util.TimingUtil;
import com.lx862.mtrscripting.wrapper.MinecraftClientWrapper;
import com.lx862.mtrscripting.wrapper.VanillaTextWrapper;
import com.lx862.mtrscripting.wrapper.VoxelShapeWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.mtr.mapping.holder.Identifier;

public class ParsedScript {
    private static final int SCRIPT_RESET_TIME = 4000;
    private final String displayName;
    private final List<Function> createFunctions;
    private final List<Function> renderFunctions;
    private final List<Function> disposeFunctions;
    private final ScriptManager scriptManager;
    private final Scriptable scope;
    private final TimingUtil timingUtil = new TimingUtil();
    private Exception capturedScriptException = null;
    private long lastFailedTime = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedScript(ScriptManager scriptManager, String displayName, String contextName, List<ScriptContent> scripts) throws NoSuchMethodException {
        this.displayName = displayName;
        this.scriptManager = scriptManager;
        this.createFunctions = new ArrayList<Function>();
        this.renderFunctions = new ArrayList<Function>();
        this.disposeFunctions = new ArrayList<Function>();
        try {
            Context cx = Context.enter();
            cx.setLanguageVersion(200);
            cx.setClassShutter(scriptManager.getClassShutter());
            this.scope = new ImporterTopLevel(cx);
            this.initBasicContextVariables(this.scope);
            scriptManager.onParseScript(contextName, cx, this.scope);
            cx.evaluateString(this.scope, "\"use strict\";", "", 1, null);
            ScriptResourceUtil.activeContext = cx;
            ScriptResourceUtil.activeScope = this.scope;
            for (ScriptContent scriptEntry : scripts) {
                Identifier scriptLocation = scriptEntry.getLocation();
                String scriptContent = scriptEntry.getContent();
                ScriptResourceUtil.executeScript(cx, this.scope, scriptLocation, scriptContent);
                this.tryAndAddFunction("create", this.scope, this.createFunctions);
                this.tryAndAddFunction("render", this.scope, this.renderFunctions);
                this.tryAndAddFunction("dispose", this.scope, this.disposeFunctions);
                this.tryAndAddFunction("create" + contextName, this.scope, this.createFunctions);
                this.tryAndAddFunction("render" + contextName, this.scope, this.renderFunctions);
                this.tryAndAddFunction("dispose" + contextName, this.scope, this.disposeFunctions);
                ScriptManager.LOGGER.info("[JCM Scripting] Loaded script: {}:{}", (Object)scriptLocation.getNamespace(), (Object)scriptLocation.getPath());
            }
        }
        finally {
            ScriptResourceUtil.activeContext = null;
            ScriptResourceUtil.activeScope = null;
            Context.exit();
        }
    }

    private void initBasicContextVariables(Scriptable scope) throws NoSuchMethodException {
        scope.put("include", scope, (Object)new NativeJavaMethod(ScriptResourceUtil.class.getMethod("includeScript", Object.class), "includeScript"));
        scope.put("print", scope, (Object)new NativeJavaMethod(ScriptResourceUtil.class.getMethod("print", Object[].class), "print"));
        scope.put("Resources", scope, (Object)new NativeJavaClass(scope, ScriptResourceUtil.class));
        scope.put("GraphicsTexture", scope, (Object)new NativeJavaClass(scope, GraphicsTexture.class));
        scope.put("Timing", scope, (Object)new NativeJavaObject(scope, this.timingUtil, TimingUtil.class));
        scope.put("StateTracker", scope, (Object)new NativeJavaClass(scope, StateTracker.class));
        scope.put("CycleTracker", scope, (Object)new NativeJavaClass(scope, CycleTracker.class));
        scope.put("RateLimit", scope, (Object)new NativeJavaClass(scope, RateLimit.class));
        scope.put("Networking", scope, (Object)new NativeJavaClass(scope, NetworkingUtil.class));
        scope.put("Files", scope, (Object)new NativeJavaClass(scope, FilesUtil.class));
        scope.put("Matrices", scope, (Object)new NativeJavaClass(scope, Matrices.class));
        scope.put("Vector3f", scope, (Object)new NativeJavaClass(scope, ScriptVector3f.class));
        scope.put("VoxelShape", scope, (Object)new NativeJavaClass(scope, VoxelShapeWrapper.class));
        scope.put("VanillaText", scope, (Object)new NativeJavaClass(scope, VanillaTextWrapper.class));
        scope.put("MinecraftClient", scope, (Object)new NativeJavaClass(scope, MinecraftClientWrapper.class));
    }

    private void tryAndAddFunction(String name, Scriptable scope, List<Function> listToAdd) {
        Object func = scope.get(name, scope);
        if (func != Scriptable.NOT_FOUND) {
            if (func instanceof Function) {
                listToAdd.add((Function)func);
            }
            scope.delete(name);
        }
    }

    public Future<?> invokeFunctions(ScriptInstance<?> scriptInstance, List<Function> functions, Runnable finishCallback) {
        if (this.duringFailCooldown()) {
            return null;
        }
        return this.scriptManager.submitScriptTask(() -> {
            if (this.duringFailCooldown()) {
                return;
            }
            this.timingUtil.prepareForScript(scriptInstance);
            try {
                Scriptable scope = this.getScope();
                Context cx = Context.enter();
                cx.setLanguageVersion(200);
                cx.setClassShutter(this.scriptManager.getClassShutter());
                if (scriptInstance.state == null) {
                    scriptInstance.state = cx.newObject(scope);
                }
                long startTime = System.nanoTime();
                for (Function func : functions) {
                    func.call(cx, scope, scope, new Object[]{scriptInstance.getScriptContext(), scriptInstance.state, scriptInstance.getWrapperObject()});
                }
                scriptInstance.setLastExecutionDurationMs(System.nanoTime() - startTime);
            }
            catch (Exception e) {
                ScriptManager.LOGGER.error("[JCM Scripting] Error executing script {}!", (Object)this.displayName, (Object)e);
                this.lastFailedTime = System.currentTimeMillis();
                this.capturedScriptException = e;
            }
            finally {
                Context.exit();
            }
            finishCallback.run();
        });
    }

    public Future<?> invokeCreateFunctions(ScriptInstance<?> instance, Runnable finishCallback) {
        return this.invokeFunctions(instance, this.createFunctions, () -> {
            instance.setCreateFunctionInvoked();
            finishCallback.run();
        });
    }

    public void invokeRenderFunctions(ScriptInstance<?> instance, Runnable finishCallback) {
        if (instance.shouldInvalidate() || instance.scriptTask != null && !instance.scriptTask.isDone()) {
            return;
        }
        instance.scriptTask = instance.isCreateFunctionInvoked() ? this.invokeFunctions(instance, this.renderFunctions, finishCallback) : this.invokeCreateFunctions(instance, () -> {});
    }

    public void invokeDisposeFunctions(ScriptInstance<?> instance, Runnable finishCallback) {
        this.invokeFunctions(instance, this.disposeFunctions, finishCallback);
    }

    public boolean duringFailCooldown() {
        return this.lastFailedTime != -1L && System.currentTimeMillis() - this.lastFailedTime <= 4000L;
    }

    public Exception getCapturedScriptException() {
        return this.capturedScriptException;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Scriptable getScope() {
        return this.scope;
    }
}

