/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.lib.org.mozilla.javascript;

import com.lx862.mtrscripting.lib.org.mozilla.javascript.AbstractEcmaObjectOperations;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Callable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Delegator;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Hashtable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.IdFunctionObject;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.IdScriptableObject;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeCollectionIterator;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeSet;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptRuntime;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptRuntimeES6;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptableObject;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Symbol;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.SymbolKey;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Undefined;
import java.util.List;
import java.util.Map;

public class NativeMap
extends IdScriptableObject {
    private static final long serialVersionUID = 1171922614280016891L;
    private static final Object MAP_TAG = "Map";
    static final String ITERATOR_TAG = "Map Iterator";
    private final Hashtable entries = new Hashtable();
    private boolean instanceOfMap = false;
    private static final int ConstructorId_groupBy = -1;
    private static final int Id_constructor = 1;
    private static final int Id_set = 2;
    private static final int Id_get = 3;
    private static final int Id_delete = 4;
    private static final int Id_has = 5;
    private static final int Id_clear = 6;
    private static final int Id_keys = 7;
    private static final int Id_values = 8;
    private static final int Id_entries = 9;
    private static final int Id_forEach = 10;
    private static final int SymbolId_getSize = 11;
    private static final int SymbolId_toStringTag = 12;
    private static final int MAX_PROTOTYPE_ID = 12;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeMap obj = new NativeMap();
        IdFunctionObject constructor = obj.exportAsJSClass(12, scope, false);
        ScriptableObject desc = (ScriptableObject)cx.newObject(scope);
        desc.put("enumerable", (Scriptable)desc, (Object)Boolean.FALSE);
        desc.put("configurable", (Scriptable)desc, (Object)Boolean.TRUE);
        desc.put("get", (Scriptable)desc, obj.get(NativeSet.GETSIZE, (Scriptable)obj));
        obj.defineOwnProperty(cx, "size", desc);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        if (sealed) {
            obj.sealObject();
        }
    }

    @Override
    public String getClassName() {
        return "Map";
    }

    @Override
    public void fillConstructorProperties(IdFunctionObject ctor) {
        this.addIdFunctionProperty(ctor, MAP_TAG, -1, "groupBy", 2);
        super.fillConstructorProperties(ctor);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(MAP_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                if (thisObj == null) {
                    NativeMap nm = new NativeMap();
                    nm.instanceOfMap = true;
                    if (args.length > 0) {
                        NativeMap.loadFromIterable(cx, scope, nm, NativeMap.key(args));
                    }
                    return nm;
                }
                throw ScriptRuntime.typeErrorById("msg.no.new", "Map");
            }
            case 2: {
                return NativeMap.realThis(thisObj, f).js_set(NativeMap.key(args), args.length > 1 ? args[1] : Undefined.instance);
            }
            case 4: {
                return NativeMap.realThis(thisObj, f).js_delete(NativeMap.key(args));
            }
            case 3: {
                return NativeMap.realThis(thisObj, f).js_get(NativeMap.key(args));
            }
            case 5: {
                return NativeMap.realThis(thisObj, f).js_has(NativeMap.key(args));
            }
            case 6: {
                return NativeMap.realThis(thisObj, f).js_clear();
            }
            case 7: {
                return NativeMap.realThis(thisObj, f).js_iterator(scope, NativeCollectionIterator.Type.KEYS);
            }
            case 8: {
                return NativeMap.realThis(thisObj, f).js_iterator(scope, NativeCollectionIterator.Type.VALUES);
            }
            case 9: {
                return NativeMap.realThis(thisObj, f).js_iterator(scope, NativeCollectionIterator.Type.BOTH);
            }
            case 10: {
                return NativeMap.realThis(thisObj, f).js_forEach(cx, scope, args.length > 0 ? args[0] : Undefined.instance, args.length > 1 ? args[1] : Undefined.instance);
            }
            case 11: {
                return NativeMap.realThis(thisObj, f).js_getSize();
            }
            case -1: {
                Object items = args.length < 1 ? Undefined.instance : args[0];
                Object callback = args.length < 2 ? Undefined.instance : args[1];
                Map<Object, List<Object>> groups = AbstractEcmaObjectOperations.groupBy(cx, scope, f, items, callback, AbstractEcmaObjectOperations.KEY_COERCION.COLLECTION);
                NativeMap map = (NativeMap)cx.newObject(scope, "Map");
                for (Map.Entry<Object, List<Object>> entry : groups.entrySet()) {
                    Scriptable elements = cx.newArray(scope, entry.getValue().toArray());
                    map.entries.put(entry.getKey(), elements);
                }
                return map;
            }
        }
        throw new IllegalArgumentException("Map.prototype has no method: " + f.getFunctionName());
    }

    private Object js_set(Object k, Object v) {
        Object key = k;
        if (key instanceof Number && ((Number)key).doubleValue() == ScriptRuntime.negativeZero) {
            key = ScriptRuntime.zeroObj;
        }
        this.entries.put(key, v);
        return this;
    }

    private Object js_delete(Object arg) {
        return this.entries.deleteEntry(arg);
    }

    private Object js_get(Object arg) {
        Hashtable.Entry entry = this.entries.getEntry(arg);
        if (entry == null) {
            return Undefined.instance;
        }
        return entry.value;
    }

    private Object js_has(Object arg) {
        return this.entries.has(arg);
    }

    private Object js_getSize() {
        return this.entries.size();
    }

    private Object js_iterator(Scriptable scope, NativeCollectionIterator.Type type) {
        return new NativeCollectionIterator(scope, ITERATOR_TAG, type, this.entries.iterator());
    }

    private Object js_clear() {
        this.entries.clear();
        return Undefined.instance;
    }

    private Object js_forEach(Context cx, Scriptable scope, Object arg1, Object arg2) {
        if (!(arg1 instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", arg1, ScriptRuntime.typeof(arg1));
        }
        Callable f = (Callable)arg1;
        boolean isStrict = cx.isStrictMode();
        for (Hashtable.Entry entry : this.entries) {
            Scriptable thisObj = ScriptRuntime.toObjectOrNull(cx, arg2, scope);
            if (thisObj == null && !isStrict) {
                thisObj = scope;
            }
            if (thisObj == null) {
                thisObj = Undefined.SCRIPTABLE_UNDEFINED;
            }
            Hashtable.Entry e = entry;
            f.call(cx, scope, thisObj, new Object[]{e.value, e.key, this});
        }
        return Undefined.instance;
    }

    static void loadFromIterable(Context cx, Scriptable scope, ScriptableObject map, Object arg1) {
        if (arg1 == null || Undefined.instance.equals(arg1)) {
            return;
        }
        Object ito = ScriptRuntime.callIterator(arg1, cx, scope);
        if (Undefined.instance.equals(ito)) {
            return;
        }
        Scriptable proto = ScriptableObject.getClassPrototype(scope, map.getClassName());
        Callable set = ScriptRuntime.getPropFunctionAndThis(proto, "set", cx, scope);
        ScriptRuntime.lastStoredScriptable(cx);
        ScriptRuntime.loadFromIterable(cx, scope, arg1, (Object key, Object value) -> set.call(cx, scope, map, new Object[]{key, value}));
    }

    private static NativeMap realThis(Scriptable thisObj, IdFunctionObject f) {
        NativeMap nm = NativeMap.ensureType((Object)thisObj, NativeMap.class, f);
        if (!nm.instanceOfMap) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", f.getFunctionName());
        }
        return nm;
    }

    @Override
    protected void initPrototypeId(int id) {
        int arity;
        switch (id) {
            case 11: {
                this.initPrototypeMethod(MAP_TAG, id, NativeSet.GETSIZE, "get size", 0);
                return;
            }
            case 12: {
                this.initPrototypeValue(12, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
                return;
            }
        }
        String fnName = null;
        this.initPrototypeMethod(MAP_TAG, id, switch (id) {
            case 1 -> {
                arity = 0;
                yield "constructor";
            }
            case 2 -> {
                arity = 2;
                yield "set";
            }
            case 3 -> {
                arity = 1;
                yield "get";
            }
            case 4 -> {
                arity = 1;
                yield "delete";
            }
            case 5 -> {
                arity = 1;
                yield "has";
            }
            case 6 -> {
                arity = 0;
                yield "clear";
            }
            case 7 -> {
                arity = 0;
                yield "keys";
            }
            case 8 -> {
                arity = 0;
                yield "values";
            }
            case 9 -> {
                arity = 0;
                yield "entries";
            }
            case 10 -> {
                arity = 1;
                yield "forEach";
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, fnName, arity);
    }

    @Override
    protected int findPrototypeId(Symbol k) {
        if (NativeSet.GETSIZE.equals(k)) {
            return 11;
        }
        if (SymbolKey.ITERATOR.equals(k)) {
            return 9;
        }
        if (SymbolKey.TO_STRING_TAG.equals(k)) {
            return 12;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "constructor" -> 1;
            case "set" -> 2;
            case "get" -> 3;
            case "delete" -> 4;
            case "has" -> 5;
            case "clear" -> 6;
            case "keys" -> 7;
            case "values" -> 8;
            case "entries" -> 9;
            case "forEach" -> 10;
            default -> 0;
        };
    }

    static Object key(Object[] args) {
        if (args.length > 0) {
            Object key = args[0];
            if (key instanceof Delegator) {
                return ((Delegator)key).getDelegee();
            }
            return key;
        }
        return Undefined.instance;
    }
}

