/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.scripting.mtr.render;

import com.lx862.jcm.mod.scripting.jcm.pids.PIDSDrawCall;
import com.lx862.jcm.mod.scripting.mtr.render.RenderDrawCall;
import com.lx862.mtrscripting.api.ScriptResultCall;
import com.lx862.mtrscripting.util.ScriptVector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.render.StoredMatrixTransformations;

public class ScriptRenderManager {
    public final List<ScriptResultCall> drawCalls = new ArrayList<ScriptResultCall>();

    public ScriptRenderManager() {
    }

    public ScriptRenderManager(List<ScriptResultCall> drawCalls) {
        this.drawCalls.addAll(drawCalls);
    }

    public void queue(ScriptResultCall call) {
        if (call instanceof RenderDrawCall) {
            ((RenderDrawCall)call).validate();
        }
        this.drawCalls.add(call);
    }

    public void invoke(World world, ScriptVector3f basePos, GraphicsHolder graphicsHolder, StoredMatrixTransformations storedMatrixTransformations, Direction facing, int light) {
        ArrayList<ScriptResultCall> drawCallsSaved = new ArrayList<ScriptResultCall>(this.drawCalls);
        List modelDrawCalls = drawCallsSaved.stream().filter(e -> !(e instanceof PIDSDrawCall)).collect(Collectors.toList());
        List pidsDrawCalls = drawCallsSaved.stream().filter(e -> e instanceof PIDSDrawCall).collect(Collectors.toList());
        for (ScriptResultCall drawCall : new ArrayList(modelDrawCalls)) {
            drawCall.run(world, basePos, graphicsHolder, storedMatrixTransformations, facing, light);
        }
        for (ScriptResultCall drawCall : new ArrayList(pidsDrawCalls)) {
            graphicsHolder.translate(0.0, 0.0, -0.02);
            graphicsHolder.push();
            drawCall.run(world, basePos, graphicsHolder, storedMatrixTransformations, facing, light);
            graphicsHolder.pop();
        }
    }

    public ScriptRenderManager copy() {
        return new ScriptRenderManager(this.drawCalls);
    }

    public void reset() {
        this.drawCalls.clear();
    }
}

