/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen;

import com.lx862.jcm.mod.render.GuiHelper;
import com.lx862.jcm.mod.render.gui.screen.base.TitledScreen;
import com.lx862.jcm.mod.util.TextUtil;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public class TestScreen
extends TitledScreen
implements GuiHelper {
    private static final Identifier TEXTURE_BACKGROUND = new Identifier("jsblock:textures/gui/config_screen/bg.png");
    private static final Identifier TEXTURE_TERRAIN = new Identifier("jsblock:textures/gui/config_screen/terrain.png");

    public TestScreen() {
        super(true);
    }

    @Override
    public MutableText getScreenTitle() {
        return TextUtil.literal("Demo Screen");
    }

    @Override
    public MutableText getScreenSubtitle() {
        return TextUtil.literal("Hello World :3");
    }

    protected void init2() {
        super.init2();
    }

    @Override
    public void drawBackground(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        double terrainHeight = (double)this.f_96543_ / 3.75;
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        GuiHelper.drawTexture(guiDrawing, TEXTURE_BACKGROUND, 0.0, 0.0, this.f_96543_, this.f_96544_);
        double translateY = (double)this.f_96544_ * (1.0 - this.animationProgress);
        GuiHelper.drawTexture(guiDrawing, TEXTURE_TERRAIN, 0.0, translateY + (double)this.f_96544_ - terrainHeight, this.f_96543_, terrainHeight);
        this.drawPride(graphicsHolder);
        this.drawSpinningText(graphicsHolder);
    }

    private void drawSpinningText(GraphicsHolder graphicsHolder) {
        graphicsHolder.push();
        graphicsHolder.translate((double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0, 0.0);
        int times = 10;
        for (int i = 0; i < times; ++i) {
            double radius = 80.0 * this.animationProgress;
            double angle = (double)i / (double)times * (Math.PI * 2) - this.elapsed / 10.0;
            double x = Math.sin(angle) * radius;
            double y = Math.cos(angle) * radius;
            graphicsHolder.push();
            graphicsHolder.translate(x, y, 0.0);
            graphicsHolder.drawCenteredText("Test", 0, 0, -1);
            graphicsHolder.pop();
        }
        graphicsHolder.pop();
    }

    private void drawPride(GraphicsHolder graphicsHolder) {
        graphicsHolder.push();
        graphicsHolder.rotateYDegrees(5.0f);
        graphicsHolder.scale((float)this.animationProgress, 1.0f, 1.0f);
        double halfWidth = (double)this.f_96543_ / 2.0;
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        GuiHelper.drawRectangle(guiDrawing, halfWidth - halfWidth * this.animationProgress, 72.0, (double)this.f_96543_ * this.animationProgress, 8.0, -2137481);
        GuiHelper.drawRectangle(guiDrawing, halfWidth - halfWidth * this.animationProgress, 80.0, (double)this.f_96543_ * this.animationProgress, 8.0, -290456);
        GuiHelper.drawRectangle(guiDrawing, halfWidth - halfWidth * this.animationProgress, 88.0, (double)this.f_96543_ * this.animationProgress, 8.0, -795796);
        GuiHelper.drawRectangle(guiDrawing, halfWidth - halfWidth * this.animationProgress, 96.0, (double)this.f_96543_ * this.animationProgress, 8.0, -8735854);
        GuiHelper.drawRectangle(guiDrawing, halfWidth - halfWidth * this.animationProgress, 104.0, (double)this.f_96543_ * this.animationProgress, 8.0, -11830084);
        GuiHelper.drawRectangle(guiDrawing, halfWidth - halfWidth * this.animationProgress, 112.0, (double)this.f_96543_ * this.animationProgress, 8.0, -9484148);
        graphicsHolder.pop();
    }
}

