/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.scripting.mtr.vehicle;

import com.lx862.jcm.mixin.modded.mtr.VehicleSchemaMixin;
import com.lx862.jcm.mixin.modded.tsc.MixinVehiclePlatformRouteInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.mtr.core.data.Depot;
import org.mtr.core.data.PathData;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Route;
import org.mtr.core.data.Station;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.VehicleCar;
import org.mtr.core.data.VehicleExtraData;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.client.VehicleRidingMovement;
import org.mtr.mod.data.VehicleExtension;

public class VehicleWrapper {
    private final VehicleExtension vehicleExtension;
    private final boolean[] doorLeftOpen;
    private final boolean[] doorRightOpen;
    private final List<PlatformInfo> allRoutePlatforms;
    private final List<PlatformInfo> thisRoutePlatforms;

    public VehicleWrapper(VehicleExtension vehicleExtension) {
        this.vehicleExtension = vehicleExtension;
        this.doorLeftOpen = new boolean[this.trainCars()];
        this.doorRightOpen = new boolean[this.trainCars()];
        for (int i = 0; i < this.trainCars(); ++i) {
            this.doorLeftOpen[i] = this.doorValue() > 0.0;
            this.doorRightOpen[i] = this.doorValue() > 0.0;
        }
        this.allRoutePlatforms = new ArrayList<PlatformInfo>();
        this.thisRoutePlatforms = new ArrayList<PlatformInfo>();
        Depot depot = (Depot)MinecraftClientData.getInstance().depotIdMap.get(vehicleExtension.vehicleExtraData.getDepotId());
        int stopIdx = 0;
        for (PathData path : this.path()) {
            if (path.getDwellTime() <= 0L || !path.getRail().isPlatform()) continue;
            VehicleExtraData.VehiclePlatformRouteInfo info = depot.getVehiclePlatformRouteInfo(stopIdx);
            Route route = ((MixinVehiclePlatformRouteInfo)info).getThisRoute();
            String destinationName = route.getDestination(stopIdx);
            Platform platform = ((MixinVehiclePlatformRouteInfo)info).getThisPlatform();
            Station station = (Station)platform.area;
            double startDistance = path.getStartDistance();
            double endDistance = path.getEndDistance();
            PlatformInfo pi = new PlatformInfo(route, station, platform, null, destinationName, startDistance, endDistance, false);
            this.allRoutePlatforms.add(pi);
            if (route.getId() == vehicleExtension.vehicleExtraData.getThisRouteId()) {
                this.thisRoutePlatforms.add(pi);
            }
            ++stopIdx;
        }
    }

    public boolean shouldRender(int carIndex) {
        return this.vehicleExtension.persistentVehicleData.rayTracing[carIndex];
    }

    @Deprecated
    public boolean shouldRenderDetail() {
        return true;
    }

    public String trainTypeId(int carIndex) {
        if (carIndex >= this.vehicleExtension.vehicleExtraData.immutableVehicleCars.size()) {
            return null;
        }
        return ((VehicleCar)this.vehicleExtension.vehicleExtraData.immutableVehicleCars.get(carIndex)).getVehicleId();
    }

    public String baseTrainType(int carIndex) {
        throw new NotImplementedException("Not implemented yet.");
    }

    public long id() {
        return this.vehicleExtension.getId();
    }

    public TransportMode transportMode() {
        return this.vehicleExtension.getTransportMode();
    }

    public double spacing(int carIndex) {
        return ((VehicleCar)this.vehicleExtension.vehicleExtraData.immutableVehicleCars.get(carIndex)).getLength();
    }

    public double width(int carIndex) {
        return ((VehicleCar)this.vehicleExtension.vehicleExtraData.immutableVehicleCars.get(carIndex)).getWidth();
    }

    public int trainCars() {
        return this.vehicleExtension.vehicleExtraData.immutableVehicleCars.size();
    }

    public double accelerationConstant() {
        return this.vehicleExtension.vehicleExtraData.getAcceleration();
    }

    public boolean manualAllowed() {
        return this.vehicleExtension.vehicleExtraData.getIsManualAllowed();
    }

    public double maxManualSpeed() {
        return this.vehicleExtension.vehicleExtraData.getMaxManualSpeed();
    }

    public double railProgress() {
        return ((VehicleSchemaMixin)this.vehicleExtension).getRailProgress();
    }

    public double getRailSpeed(int pathIndex) {
        return ((PathData)this.vehicleExtension.vehicleExtraData.immutablePath.get(pathIndex)).getSpeedLimitMetersPerMillisecond();
    }

    public double speed() {
        return this.vehicleExtension.getSpeed();
    }

    public double doorValue() {
        return this.vehicleExtension.persistentVehicleData.getDoorValue();
    }

    public List<PathData> path() {
        return this.vehicleExtension.vehicleExtraData.immutablePath;
    }

    public boolean isDoorOpening() {
        return this.vehicleExtension.persistentVehicleData.getAdjustedDoorMultiplier(this.vehicleExtension.vehicleExtraData) > 0;
    }

    public boolean isCurrentlyManual() {
        return this.vehicleExtension.vehicleExtraData.getIsCurrentlyManual();
    }

    public boolean isReversed() {
        return this.vehicleExtension.getReversed();
    }

    public boolean isOnRoute() {
        return this.vehicleExtension.getIsOnRoute();
    }

    public boolean isClientPlayerRiding() {
        return VehicleRidingMovement.isRiding((long)this.vehicleExtension.getId());
    }

    public List<PlatformInfo> getThisRoutePlatforms() {
        return this.thisRoutePlatforms;
    }

    public List<PlatformInfo> getAllRoutePlatforms() {
        return this.allRoutePlatforms;
    }

    public static class PlatformInfo {
        public Route route;
        public Station station;
        public Platform platform;
        public Station destinationStation;
        public String destinationName;
        public double startDistance;
        public double endDistance;
        public boolean reverseAtPlatform;

        public PlatformInfo(Route route, Station station, Platform platform, Station destinationStation, String destinationName, double startDistance, double endDistance, boolean reverseAtPlatform) {
            this.route = route;
            this.station = station;
            this.platform = platform;
            this.destinationStation = destinationStation;
            this.destinationName = destinationName;
            this.startDistance = startDistance;
            this.endDistance = endDistance;
            this.reverseAtPlatform = reverseAtPlatform;
        }
    }
}

