/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block;

import com.lx862.jcm.mod.block.base.DirectionalBlock;
import com.lx862.jcm.mod.registry.Blocks;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mod.block.IBlock;

public class CircleWallBlock
extends DirectionalBlock {
    public CircleWallBlock(BlockSettings settings) {
        super(settings);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        BlockState superState = super.getPlacementState2(ctx);
        if (superState != null && ctx.getPlayer() != null && this.autoPlace(ctx.getWorld(), ctx.getBlockPos(), superState, ctx.getPlayerFacing())) {
            ctx.getPlayer().swingHand(ctx.getHand(), !ctx.getWorld().isClient());
            return null;
        }
        return superState;
    }

    public boolean isTranslucent2(BlockState state, BlockView world, BlockPos pos) {
        return false;
    }

    public VoxelShape getCullingShape2(BlockState state, BlockView world, BlockPos pos) {
        return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
    }

    private boolean autoPlace(World world, BlockPos pos, BlockState state, Direction playerFacing) {
        Block thisBlock = this.asBlock2();
        Block blockBelow = world.getBlockState(pos.down()).getBlock();
        BlockPos shiftedBlockPos = null;
        if (blockBelow.equals((Object)Blocks.CIRCLE_WALL_1.get()) && thisBlock.equals((Object)Blocks.CIRCLE_WALL_2.get())) {
            shiftedBlockPos = pos.offset(playerFacing);
        }
        if (blockBelow.equals((Object)Blocks.CIRCLE_WALL_4.get()) && thisBlock.equals((Object)Blocks.CIRCLE_WALL_5.get()) || blockBelow.equals((Object)Blocks.CIRCLE_WALL_5.get()) && thisBlock.equals((Object)Blocks.CIRCLE_WALL_6.get())) {
            shiftedBlockPos = pos.offset(playerFacing.getOpposite());
        }
        if (shiftedBlockPos != null && world.getBlockState(shiftedBlockPos).isAir()) {
            world.setBlockState(shiftedBlockPos, state);
            return true;
        }
        return false;
    }
}

