/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen;

import com.lx862.jcm.mod.block.entity.PIDSBlockEntity;
import com.lx862.jcm.mod.data.pids.PIDSManager;
import com.lx862.jcm.mod.network.block.PIDSUpdatePacket;
import com.lx862.jcm.mod.registry.Blocks;
import com.lx862.jcm.mod.registry.Networking;
import com.lx862.jcm.mod.render.gui.screen.PIDSPresetScreen;
import com.lx862.jcm.mod.render.gui.screen.base.BlockConfigListScreen;
import com.lx862.jcm.mod.render.gui.widget.ContentItem;
import com.lx862.jcm.mod.render.gui.widget.HorizontalWidgetSet;
import com.lx862.jcm.mod.render.gui.widget.MappedWidget;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import net.minecraft.class_339;
import net.minecraft.class_437;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Station;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.screen.DashboardListSelectorScreen;
import org.mtr.mod.screen.PIDSConfigScreen;

public class PIDSScreen
extends BlockConfigListScreen {
    protected final TextFieldWidgetExtension[] customMessagesWidgets;
    protected final CheckboxWidgetExtension[] rowHiddenWidgets;
    protected final CheckboxWidgetExtension hidePlatformNumber;
    protected final ButtonWidgetExtension choosePresetButton;
    protected final ButtonWidgetExtension choosePlatformButton;
    protected LongAVLTreeSet filteredPlatforms = new LongAVLTreeSet();
    protected String presetId;

    public PIDSScreen(BlockPos blockPos, String[] customMessages, boolean[] rowHidden, boolean hidePlatformNumber, String presetId) {
        super(blockPos);
        BlockEntity be;
        int i;
        this.customMessagesWidgets = new TextFieldWidgetExtension[customMessages.length];
        this.rowHiddenWidgets = new CheckboxWidgetExtension[rowHidden.length];
        for (i = 0; i < customMessages.length; ++i) {
            String customMessage = customMessages[i];
            this.customMessagesWidgets[i] = new TextFieldWidgetExtension(0, 0, 120, 20, "", 100, TextCase.DEFAULT, null, TextUtil.translatable(TextCategory.GUI, "pids.listview.widget.custom_message", new Object[0]).getString());
            this.customMessagesWidgets[i].setText2(customMessage);
        }
        for (i = 0; i < rowHidden.length; ++i) {
            boolean rowIsHidden = rowHidden[i];
            this.rowHiddenWidgets[i] = new CheckboxWidgetExtension(0, 0, 120, 20, true, cb -> {});
            this.rowHiddenWidgets[i].setChecked(rowIsHidden);
            this.rowHiddenWidgets[i].setMessage2(Text.cast((HolderBase)TextUtil.translatable(TextCategory.GUI, "pids.listview.widget.row_hidden", new Object[0])));
        }
        this.hidePlatformNumber = new CheckboxWidgetExtension(0, 0, 20, 20, true, cb -> {});
        this.hidePlatformNumber.setChecked(hidePlatformNumber);
        this.choosePresetButton = new ButtonWidgetExtension(0, 0, 60, 20, TextUtil.translatable(TextCategory.GUI, "pids.listview.widget.choose_preset", new Object[0]), btn -> MinecraftClient.getInstance().openScreen(new Screen((class_437)new PIDSPresetScreen(blockPos, presetId, str -> {
            this.presetId = str;
        }).withPreviousScreen(new Screen((class_437)this)))));
        this.choosePlatformButton = new ButtonWidgetExtension(0, 0, 60, 20, TextUtil.translatable(TextCategory.GUI, "pids.listview.widget.change_platform", new Object[0]), btn -> {
            ObjectImmutableList platformsForList;
            Station station = InitClient.findStation((BlockPos)blockPos);
            if (station != null) {
                platformsForList = PIDSConfigScreen.getPlatformsForList((ObjectArrayList)new ObjectArrayList((ObjectCollection)station.savedRails));
            } else {
                ObjectArrayList nearbyPlatforms = new ObjectArrayList();
                InitClient.findClosePlatform((BlockPos)blockPos.down(4), (int)5, arg_0 -> ((ObjectArrayList)nearbyPlatforms).add(arg_0));
                platformsForList = PIDSConfigScreen.getPlatformsForList((ObjectArrayList)nearbyPlatforms);
            }
            MinecraftClient.getInstance().openScreen(new Screen((class_437)new DashboardListSelectorScreen(new ObjectImmutableList((ObjectList)platformsForList), (LongCollection)this.filteredPlatforms, false, false, (ScreenExtension)this)));
        });
        this.presetId = presetId;
        if (MinecraftClient.getInstance().getWorldMapped() != null && (be = MinecraftClient.getInstance().getWorldMapped().getBlockEntity(blockPos)) != null && be.data instanceof PIDSBlockEntity) {
            this.filteredPlatforms = ((PIDSBlockEntity)((Object)be.data)).getPlatformIds();
        }
    }

    @Override
    public MutableText getScreenTitle() {
        return Blocks.RV_PIDS.get().getName();
    }

    @Override
    public void addConfigEntries() {
        this.addChild(new ClickableWidget((class_339)this.choosePresetButton));
        ContentItem presetEntry = new ContentItem(TextUtil.translatable(TextCategory.GUI, "pids.listview.title.pids_preset", new Object[0]), new MappedWidget(this.choosePresetButton), 26);
        presetEntry.setIconCallback((guiDrawing, startX, startY, width, height) -> PIDSPresetScreen.drawPIDSPreview(PIDSManager.getPreset(this.presetId), guiDrawing, startX, startY, width, height, true));
        this.listViewWidget.add(presetEntry);
        ObjectArrayList platformList = new ObjectArrayList();
        LongBidirectionalIterator longBidirectionalIterator = this.filteredPlatforms.iterator();
        while (longBidirectionalIterator.hasNext()) {
            long filteredPlatform = (Long)longBidirectionalIterator.next();
            Platform platform = MinecraftClientData.getInstance().platforms.stream().filter(p -> p.getId() == filteredPlatform).findFirst().orElse(null);
            if (platform == null) {
                platformList.add((Object)"?");
                continue;
            }
            platformList.add((Object)platform.getName());
        }
        String platforms = String.join((CharSequence)",", (Iterable<? extends CharSequence>)platformList);
        this.listViewWidget.add(this.filteredPlatforms.isEmpty() ? TextUtil.translatable(TextCategory.GUI, "pids.listview.title.filtered_platform.nearby", new Object[0]) : TextUtil.translatable(TextCategory.GUI, "pids.listview.title.filtered_platform", platforms), new MappedWidget(this.choosePlatformButton));
        this.addChild(new ClickableWidget((class_339)this.choosePlatformButton));
        for (int i = 0; i < this.customMessagesWidgets.length; ++i) {
            this.addChild(new ClickableWidget((class_339)this.customMessagesWidgets[i]));
            this.addChild(new ClickableWidget((class_339)this.rowHiddenWidgets[i]));
            int w = this.listViewWidget.getWidth2();
            this.rowHiddenWidgets[i].setWidth2(95);
            this.customMessagesWidgets[i].setWidth2(w - this.rowHiddenWidgets[i].getWidth2() - 18);
            HorizontalWidgetSet widgetSet = new HorizontalWidgetSet();
            widgetSet.addWidget(new MappedWidget(this.customMessagesWidgets[i]));
            widgetSet.addWidget(new MappedWidget(this.rowHiddenWidgets[i]));
            widgetSet.setXYSize(this.listViewWidget.getX2(), 20, this.listViewWidget.getWidth2(), 20);
            this.listViewWidget.add(null, new MappedWidget(widgetSet));
        }
        this.addChild(new ClickableWidget((class_339)this.hidePlatformNumber));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "pids.listview.title.hide_platform_number", new Object[0]), new MappedWidget(this.hidePlatformNumber));
    }

    @Override
    public void onSave() {
        int i;
        String[] customMessages = new String[this.customMessagesWidgets.length];
        boolean[] rowHidden = new boolean[this.rowHiddenWidgets.length];
        for (i = 0; i < this.customMessagesWidgets.length; ++i) {
            customMessages[i] = this.customMessagesWidgets[i].getText2();
        }
        for (i = 0; i < this.rowHiddenWidgets.length; ++i) {
            rowHidden[i] = this.rowHiddenWidgets[i].isChecked2();
        }
        Networking.sendPacketToServer(new PIDSUpdatePacket(this.blockPos, this.filteredPlatforms, customMessages, rowHidden, this.hidePlatformNumber.isChecked2(), this.presetId));
    }
}

