/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block.behavior;

import com.lx862.jcm.mod.data.BlockProperties;
import com.lx862.jcm.mod.util.BlockUtil;
import org.mtr.mapping.holder.Axis;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mod.block.IBlock;

public interface VerticalDoubleBlock {
    public static final EnumProperty<IBlock.DoubleBlockHalf> HALF = BlockProperties.VERTICAL_2;

    public static boolean canBePlaced(World world, BlockPos pos, ItemPlacementContext ctx) {
        return BlockUtil.isReplacable(world, pos, Direction.UP, ctx, 2);
    }

    public static void placeBlock(World world, BlockPos startPos, BlockState state) {
        world.setBlockState(startPos.up(), state.with(new Property((net.minecraft.world.level.block.state.properties.Property)VerticalDoubleBlock.HALF.data), (Comparable)IBlock.DoubleBlockHalf.UPPER));
    }

    public static BlockPos getLootDropPos(BlockState state, BlockPos pos) {
        switch ((IBlock.DoubleBlockHalf)IBlock.getStatePropertySafe((BlockState)state, (Property)new Property((net.minecraft.world.level.block.state.properties.Property)VerticalDoubleBlock.HALF.data))) {
            case LOWER: {
                return pos;
            }
            case UPPER: {
                return pos.down();
            }
        }
        return pos;
    }

    public static boolean blockNotValid(Block blockInstance, WorldAccess world, BlockPos pos, BlockState state) {
        IBlock.DoubleBlockHalf thisPart = (IBlock.DoubleBlockHalf)IBlock.getStatePropertySafe((BlockState)state, (Property)new Property((net.minecraft.world.level.block.state.properties.Property)VerticalDoubleBlock.HALF.data));
        int offset = thisPart == IBlock.DoubleBlockHalf.UPPER ? -1 : 1;
        return !world.getBlockState(pos.offset(Axis.Y, offset)).isOf(blockInstance);
    }
}

