/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.data.pids.preset.components;

import com.google.gson.JsonObject;
import com.lx862.jcm.mod.data.KVPair;
import com.lx862.jcm.mod.data.pids.preset.PIDSContext;
import com.lx862.jcm.mod.data.pids.preset.components.base.PIDSComponent;
import com.lx862.jcm.mod.data.pids.preset.components.base.TextComponent;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.WorldHelper;

public class ClockComponent
extends TextComponent {
    private final boolean use24h;
    private final boolean showHour;
    private final boolean showMin;
    private final boolean showAMPM;

    public ClockComponent(double x, double y, double width, double height, KVPair additionalParam) {
        super(x, y, width, height, additionalParam);
        this.use24h = additionalParam.get("use24h", true);
        this.showHour = additionalParam.get("showHour", true);
        this.showMin = additionalParam.get("showMin", true);
        this.showAMPM = additionalParam.get("showAMPM", false);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, Direction facing, PIDSContext context) {
        long timeNow = WorldHelper.getTimeOfDay((World)context.world) + 6000L;
        long hours = timeNow / 1000L;
        long minutes = (long)Math.floor((double)(timeNow - hours * 1000L) / 16.8);
        Object str = "";
        if (this.showHour) {
            str = this.use24h ? (String)str + String.format("%02d", hours % 24L) : (String)str + hours % 12L;
        }
        if (this.showHour && this.showMin) {
            str = (String)str + ":";
        }
        if (this.showMin) {
            str = (String)str + String.format("%02d", minutes % 60L);
        }
        if (this.showMin && this.showAMPM) {
            str = (String)str + " ";
        }
        if (this.showAMPM) {
            str = (String)str + (hours % 24L >= 12L ? "PM" : "AM");
        }
        this.drawText(graphicsHolder, guiDrawing, facing, (String)str);
    }

    public static PIDSComponent parseComponent(double x, double y, double width, double height, JsonObject jsonObject) {
        return new ClockComponent(x, y, width, height, new KVPair(jsonObject));
    }
}

