/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.text.font;

import com.google.common.base.Charsets;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lx862.jcm.mod.render.text.font.FontSet;
import com.lx862.jcm.mod.render.text.font.NoTTFFontException;
import com.lx862.jcm.mod.util.JCMLogger;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ResourceManagerHelper;

public class FontManager {
    public static final HashMap<Identifier, FontSet> fonts = new HashMap();

    public static void initialize() {
        fonts.clear();
        JCMLogger.debug("[FontManager] Loading TTF fonts", new Object[0]);
        ResourceManagerHelper.readDirectory((String)"font", (path, is) -> {
            if (path.getPath().endsWith(".json")) {
                FontManager.loadVanillaFont(path);
            }
        });
    }

    public static void loadVanillaFont(Identifier path) {
        Identifier fontId = new Identifier(path.getNamespace(), path.getPath().replace("font/", "").replace(".json", ""));
        if (fonts.containsKey(fontId)) {
            return;
        }
        ResourceManagerHelper.readResource((Identifier)path, inputStream -> {
            try {
                JsonObject jsonObject = new JsonParser().parse(IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8)).getAsJsonObject();
                JCMLogger.debug("[FontManager] Try load TTF font {}:{} from {}:{}", fontId.getNamespace(), fontId.getPath(), path.getNamespace(), path.getPath());
                fonts.put(fontId, new FontSet(jsonObject));
            }
            catch (NoTTFFontException e) {
                JCMLogger.debug("[FontManager] No TTF Font found for font: {}", path.getNamespace() + ":" + path.getPath());
            }
            catch (Exception e) {
                JCMLogger.error("[FontManager] Failed to read font json: {} ({})", path.getNamespace() + ":" + path.getPath(), e.getMessage());
            }
        });
    }

    public static FontSet getFontSet(Identifier path) {
        return fonts.get(path);
    }
}

