/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.lib.org.mozilla.javascript.optimizer;

import com.lx862.mtrscripting.lib.org.mozilla.javascript.Callable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptRuntime;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.optimizer.ParsedOperation;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.optimizer.RhinoNamespace;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.optimizer.RhinoOperation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.dynalink.StandardNamespace;
import jdk.dynalink.StandardOperation;
import jdk.dynalink.linker.GuardedInvocation;
import jdk.dynalink.linker.GuardingDynamicLinker;
import jdk.dynalink.linker.LinkRequest;
import jdk.dynalink.linker.LinkerServices;

class DefaultLinker
implements GuardingDynamicLinker {
    static final boolean DEBUG;

    DefaultLinker() {
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest req, LinkerServices svc) throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType mType = req.getCallSiteDescriptor().getMethodType();
        ParsedOperation op = new ParsedOperation(req.getCallSiteDescriptor().getOperation());
        GuardedInvocation invocation = this.getInvocation(lookup, mType, op);
        if (DEBUG) {
            String t1 = req.getReceiver() == null ? "null" : req.getReceiver().getClass().getSimpleName();
            String t2 = "";
            if (req.getArguments().length > 1 && req.getArguments()[1] != null) {
                t2 = req.getArguments()[1].getClass().getSimpleName();
            }
            System.out.println(String.valueOf(op) + "(" + t1 + ", " + t2 + "): default link");
        }
        return invocation;
    }

    private GuardedInvocation getInvocation(MethodHandles.Lookup lookup, MethodType mType, ParsedOperation op) throws NoSuchMethodException, IllegalAccessException {
        if (op.isNamespace(StandardNamespace.PROPERTY)) {
            return this.getPropertyInvocation(lookup, mType, op);
        }
        if (op.isNamespace(RhinoNamespace.NAME)) {
            return this.getNameInvocation(lookup, mType, op);
        }
        if (op.isNamespace(RhinoNamespace.MATH)) {
            return this.getMathInvocation(lookup, mType, op);
        }
        throw new UnsupportedOperationException(op.toString());
    }

    private GuardedInvocation getPropertyInvocation(MethodHandles.Lookup lookup, MethodType mType, ParsedOperation op) throws NoSuchMethodException, IllegalAccessException {
        MethodHandle mh = null;
        if (op.isOperation(StandardOperation.GET)) {
            mh = DefaultLinker.bindStringParameter(lookup, mType, ScriptRuntime.class, "getObjectProp", 1, op.getName());
        } else if (op.isOperation(RhinoOperation.GETNOWARN)) {
            mh = DefaultLinker.bindStringParameter(lookup, mType, ScriptRuntime.class, "getObjectPropNoWarn", 1, op.getName());
        } else if (op.isOperation(RhinoOperation.GETSUPER)) {
            mh = DefaultLinker.bindStringParameter(lookup, mType, ScriptRuntime.class, "getSuperProp", 1, op.getName());
        } else if (op.isOperation(RhinoOperation.GETWITHTHIS)) {
            mh = DefaultLinker.bindStringParameter(lookup, mType, ScriptRuntime.class, "getPropFunctionAndThis", 1, op.getName());
        } else if (op.isOperation(RhinoOperation.GETWITHTHISOPTIONAL)) {
            mh = DefaultLinker.bindStringParameter(lookup, mType, ScriptRuntime.class, "getPropFunctionAndThisOptional", 1, op.getName());
        } else if (op.isOperation(StandardOperation.SET)) {
            mh = DefaultLinker.bindStringParameter(lookup, mType, ScriptRuntime.class, "setObjectProp", 1, op.getName());
        } else if (op.isOperation(RhinoOperation.SETSUPER)) {
            mh = DefaultLinker.bindStringParameter(lookup, mType, ScriptRuntime.class, "setSuperProp", 1, op.getName());
        } else if (op.isOperation(RhinoOperation.GETELEMENT)) {
            mh = lookup.findStatic(ScriptRuntime.class, "getObjectElem", mType);
        } else if (op.isOperation(RhinoOperation.GETELEMENTSUPER)) {
            mh = lookup.findStatic(ScriptRuntime.class, "getSuperElem", mType);
        } else if (op.isOperation(RhinoOperation.GETINDEX)) {
            mh = lookup.findStatic(ScriptRuntime.class, "getObjectIndex", mType);
        } else if (op.isOperation(RhinoOperation.SETELEMENT)) {
            mh = lookup.findStatic(ScriptRuntime.class, "setObjectElem", mType);
        } else if (op.isOperation(RhinoOperation.SETELEMENTSUPER)) {
            mh = lookup.findStatic(ScriptRuntime.class, "setSuperElem", mType);
        } else if (op.isOperation(RhinoOperation.SETINDEX)) {
            mh = lookup.findStatic(ScriptRuntime.class, "setObjectIndex", mType);
        }
        if (mh != null) {
            return new GuardedInvocation(mh);
        }
        throw new UnsupportedOperationException(op.toString());
    }

    private GuardedInvocation getNameInvocation(MethodHandles.Lookup lookup, MethodType mType, ParsedOperation op) throws NoSuchMethodException, IllegalAccessException {
        MethodHandle mh = null;
        String name = op.getName();
        if (op.isOperation(RhinoOperation.BIND)) {
            MethodType tt = MethodType.methodType(Scriptable.class, Context.class, Scriptable.class, String.class);
            mh = lookup.findStatic(ScriptRuntime.class, "bind", tt);
            mh = MethodHandles.insertArguments(mh, 2, name);
            mh = MethodHandles.permuteArguments(mh, mType, 1, 0);
        } else if (op.isOperation(StandardOperation.GET)) {
            MethodType tt = MethodType.methodType(Object.class, Context.class, Scriptable.class, String.class);
            mh = lookup.findStatic(ScriptRuntime.class, "name", tt);
            mh = MethodHandles.insertArguments(mh, 2, name);
            mh = MethodHandles.permuteArguments(mh, mType, 1, 0);
        } else if (op.isOperation(RhinoOperation.GETWITHTHIS)) {
            MethodType tt = MethodType.methodType(Callable.class, String.class, Context.class, Scriptable.class);
            mh = lookup.findStatic(ScriptRuntime.class, "getNameFunctionAndThis", tt);
            mh = MethodHandles.insertArguments(mh, 0, name);
            mh = MethodHandles.permuteArguments(mh, mType, 1, 0);
        } else if (op.isOperation(RhinoOperation.GETWITHTHISOPTIONAL)) {
            MethodType tt = MethodType.methodType(Callable.class, String.class, Context.class, Scriptable.class);
            mh = lookup.findStatic(ScriptRuntime.class, "getNameFunctionAndThisOptional", tt);
            mh = MethodHandles.insertArguments(mh, 0, name);
            mh = MethodHandles.permuteArguments(mh, mType, 1, 0);
        } else if (op.isOperation(StandardOperation.SET)) {
            mh = DefaultLinker.bindStringParameter(lookup, mType, ScriptRuntime.class, "setName", 4, name);
        } else if (op.isOperation(RhinoOperation.SETSTRICT)) {
            mh = DefaultLinker.bindStringParameter(lookup, mType, ScriptRuntime.class, "strictSetName", 4, name);
        } else if (op.isOperation(RhinoOperation.SETCONST)) {
            mh = DefaultLinker.bindStringParameter(lookup, mType, ScriptRuntime.class, "setConst", 3, name);
        }
        if (mh != null) {
            return new GuardedInvocation(mh);
        }
        throw new UnsupportedOperationException(op.toString());
    }

    private GuardedInvocation getMathInvocation(MethodHandles.Lookup lookup, MethodType mType, ParsedOperation op) throws NoSuchMethodException, IllegalAccessException {
        MethodHandle mh = null;
        if (op.isOperation(RhinoOperation.ADD)) {
            mh = lookup.findStatic(ScriptRuntime.class, "add", mType);
        } else if (op.isOperation(RhinoOperation.TONUMBER)) {
            mh = lookup.findStatic(ScriptRuntime.class, "toNumber", mType);
        } else if (op.isOperation(RhinoOperation.TONUMERIC)) {
            mh = lookup.findStatic(ScriptRuntime.class, "toNumeric", mType);
        } else if (op.isOperation(RhinoOperation.TOBOOLEAN)) {
            mh = lookup.findStatic(ScriptRuntime.class, "toBoolean", mType);
        } else if (op.isOperation(RhinoOperation.TOINT32)) {
            mh = lookup.findStatic(ScriptRuntime.class, "toInt32", mType);
        } else if (op.isOperation(RhinoOperation.TOUINT32)) {
            mh = lookup.findStatic(ScriptRuntime.class, "toUint32", mType);
        } else if (op.isOperation(RhinoOperation.EQ)) {
            mh = lookup.findStatic(ScriptRuntime.class, "eq", mType);
        } else if (op.isOperation(RhinoOperation.SHALLOWEQ)) {
            mh = lookup.findStatic(ScriptRuntime.class, "shallowEq", mType);
        } else if (op.isOperation(RhinoOperation.COMPARE_GT)) {
            mh = this.makeCompare(lookup, 16);
        } else if (op.isOperation(RhinoOperation.COMPARE_LT)) {
            mh = this.makeCompare(lookup, 14);
        } else if (op.isOperation(RhinoOperation.COMPARE_GE)) {
            mh = this.makeCompare(lookup, 17);
        } else if (op.isOperation(RhinoOperation.COMPARE_LE)) {
            mh = this.makeCompare(lookup, 15);
        }
        if (mh != null) {
            return new GuardedInvocation(mh);
        }
        throw new UnsupportedOperationException(op.toString());
    }

    private MethodHandle makeCompare(MethodHandles.Lookup lookup, int op) throws NoSuchMethodException, IllegalAccessException {
        MethodType tt = MethodType.methodType(Boolean.TYPE, Object.class, Object.class, Integer.TYPE);
        MethodHandle mh = lookup.findStatic(ScriptRuntime.class, "compare", tt);
        mh = MethodHandles.insertArguments(mh, 2, op);
        return mh;
    }

    private static MethodHandle bindStringParameter(MethodHandles.Lookup lookup, MethodType mt, Class<?> cls, String method, int index, String nameParam) throws NoSuchMethodException, IllegalAccessException {
        MethodType actualType = mt.insertParameterTypes(index, String.class);
        MethodHandle mh = lookup.findStatic(cls, method, actualType);
        return MethodHandles.insertArguments(mh, index, nameParam);
    }

    static {
        String debugVal = System.getProperty("RHINO_DEBUG_LINKER");
        if (debugVal == null) {
            debugVal = System.getenv("RHINO_DEBUG_LINKER");
        }
        DEBUG = Boolean.parseBoolean(debugVal);
    }
}

