/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.wrapper;

import com.lx862.jcm.mapping.LoaderImpl;
import com.lx862.mtrscripting.util.ScriptVector3f;
import com.lx862.mtrscripting.wrapper.PlayerEntityWrapper;
import com.lx862.mtrscripting.wrapper.VanillaTextWrapper;
import com.mojang.text2speech.Narrator;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Scoreboard;
import org.mtr.mapping.holder.ScoreboardObjective;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ScoreboardHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.mapper.WorldHelper;
import org.mtr.mapping.tool.HolderBase;

public class MinecraftClientWrapper {
    public static boolean worldIsRaining() {
        return MinecraftClient.getInstance().getWorldMapped() != null && MinecraftClient.getInstance().getWorldMapped().isRaining();
    }

    public static boolean worldIsThundering() {
        return MinecraftClient.getInstance().getWorldMapped() != null && MinecraftClient.getInstance().getWorldMapped().isThundering();
    }

    public static boolean worldIsRainingAt(ScriptVector3f pos) {
        return MinecraftClient.getInstance().getWorldMapped() != null && LoaderImpl.isRainingAt(World.cast((HolderBase)MinecraftClient.getInstance().getWorldMapped()), pos.rawBlockPos());
    }

    public static int worldDayTime() {
        return MinecraftClient.getInstance().getWorldMapped() != null ? (int)WorldHelper.getTimeOfDay((ClientWorld)MinecraftClient.getInstance().getWorldMapped()) : 0;
    }

    public static boolean isEmittingRedstonePower(ScriptVector3f pos) {
        for (Direction direction : Direction.values()) {
            if (!MinecraftClientWrapper.isEmittingRedstonePower(pos, direction)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmittingRedstonePower(ScriptVector3f pos, Direction direction) {
        return MinecraftClient.getInstance().getWorldMapped() != null && MinecraftClient.getInstance().getWorldMapped().isEmittingRedstonePower(pos.rawBlockPos(), direction);
    }

    public static void narrate(String message) {
        MinecraftClient.getInstance().execute(() -> Narrator.getNarrator().say(message, true));
    }

    public static int blockLightAt(ScriptVector3f pos) {
        return MinecraftClient.getInstance().getWorldMapped().getLightLevel(LightType.BLOCK, pos.rawBlockPos());
    }

    public static int skyLightAt(ScriptVector3f pos) {
        return MinecraftClient.getInstance().getWorldMapped().getLightLevel(LightType.SKY, pos.rawBlockPos());
    }

    public static int lightLevelAt(ScriptVector3f pos) {
        return Math.min(MinecraftClientWrapper.blockLightAt(pos), MinecraftClientWrapper.skyLightAt(pos));
    }

    public PlayerEntityWrapper localPlayer() {
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return null;
        }
        return new PlayerEntityWrapper(PlayerEntity.cast((HolderBase)clientPlayerEntity));
    }

    public static Integer getScoreboardScore(String objectiveName, String playerName) {
        ClientWorld world = MinecraftClient.getInstance().getWorldMapped();
        Scoreboard scoreboard = world.getScoreboard();
        ScoreboardObjective objective = ScoreboardHelper.getScoreboardObjective((Scoreboard)scoreboard, (String)objectiveName);
        if (objective == null) {
            return null;
        }
        return ScoreboardHelper.getPlayerScore((Scoreboard)scoreboard, (String)playerName, (ScoreboardObjective)objective);
    }

    public static boolean gamePaused() {
        return MinecraftClient.getInstance().isPaused();
    }

    public static void displayMessage(String message, boolean actionBar) {
        MinecraftClientWrapper.displayMessage(Text.cast((HolderBase)TextHelper.literal((String)message)), actionBar);
    }

    public static void displayMessage(VanillaTextWrapper vanillaTextWrapper, boolean actionBar) {
        MinecraftClientWrapper.displayMessage(Text.cast((HolderBase)vanillaTextWrapper.impl()), actionBar);
    }

    private static void displayMessage(Text text, boolean actionBar) {
        ClientPlayerEntity player = MinecraftClient.getInstance().getPlayerMapped();
        if (player != null) {
            MinecraftClient.getInstance().execute(() -> player.sendMessage(text, actionBar));
        }
    }
}

