/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.wrapper;

import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mod.block.IBlock;

public class VoxelShapeWrapper {
    private final VoxelShape impl;

    public VoxelShapeWrapper(VoxelShape impl) {
        this.impl = impl;
    }

    public static VoxelShapeWrapper empty() {
        return new VoxelShapeWrapper(VoxelShapes.empty());
    }

    public static VoxelShapeWrapper fullCube() {
        return new VoxelShapeWrapper(VoxelShapes.fullCube());
    }

    public static VoxelShapeWrapper create(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return new VoxelShapeWrapper(Block.createCuboidShape((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
    }

    public static VoxelShapeWrapper create(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Direction facing) {
        return new VoxelShapeWrapper(IBlock.getVoxelShapeByDirection((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Direction)facing));
    }

    public VoxelShapeWrapper combine(VoxelShapeWrapper other) {
        return new VoxelShapeWrapper(VoxelShapes.union((VoxelShape)this.impl, (VoxelShape)other.impl));
    }

    public VoxelShape impl() {
        return this.impl;
    }
}

