/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.lib.org.mozilla.javascript.ast;

import com.lx862.mtrscripting.lib.org.mozilla.javascript.Token;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ast.AstNode;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ast.Comment;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ast.NodeVisitor;
import java.util.ArrayList;
import java.util.List;

public class SwitchCase
extends AstNode {
    private AstNode expression;
    private List<AstNode> statements;

    public SwitchCase() {
        this.type = 128;
    }

    public SwitchCase(int pos) {
        super(pos);
        this.type = 128;
    }

    public SwitchCase(int pos, int len) {
        super(pos, len);
        this.type = 128;
    }

    public AstNode getExpression() {
        return this.expression;
    }

    public void setExpression(AstNode expression) {
        this.expression = expression;
        if (expression != null) {
            expression.setParent(this);
        }
    }

    public boolean isDefault() {
        return this.expression == null;
    }

    public List<AstNode> getStatements() {
        return this.statements;
    }

    public void setStatements(List<AstNode> statements) {
        if (this.statements != null) {
            this.statements.clear();
        }
        for (AstNode s : statements) {
            this.addStatement(s);
        }
    }

    public void addStatement(AstNode statement) {
        this.assertNotNull(statement);
        if (this.statements == null) {
            this.statements = new ArrayList<AstNode>();
        }
        int end = statement.getPosition() + statement.getLength();
        this.setLength(end - this.getPosition());
        this.statements.add(statement);
        statement.setParent(this);
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        if (this.expression == null) {
            sb.append("default:\n");
        } else {
            sb.append("case ");
            sb.append(this.expression.toSource(0));
            sb.append(":");
            if (this.getInlineComment() != null) {
                sb.append(this.getInlineComment().toSource(depth + 1));
            }
            sb.append("\n");
        }
        if (this.statements != null) {
            for (AstNode s : this.statements) {
                sb.append(s.toSource(depth + 1));
                if (s.getType() != 175 || ((Comment)s).getCommentType() != Token.CommentType.LINE) continue;
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        if (v.visit(this)) {
            if (this.expression != null) {
                this.expression.visit(v);
            }
            if (this.statements != null) {
                for (AstNode s : this.statements) {
                    s.visit(v);
                }
            }
        }
    }
}

