/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lx862.jcm.mod.JCMClient;
import com.lx862.jcm.mod.scripting.mtr.MTRScripting;
import com.lx862.jcm.mod.util.JCMLogger;
import com.lx862.mtrscripting.core.ParsedScript;
import com.lx862.mtrscripting.data.ScriptContent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ResourceManagerHelper;

public class MTRContentResourceManager {
    private static final HashMap<String, ParsedScript> vehicleScripts = new HashMap();
    private static final HashMap<String, ParsedScript> eyecandyScripts = new HashMap();
    private static final JsonParser JSON_PARSER = new JsonParser();

    public static void reload() {
        JCMLogger.info("Loading scripts on-behalf of MTR...", new Object[0]);
        eyecandyScripts.clear();
        vehicleScripts.clear();
        MTRContentResourceManager.readNteEyecandy();
        MTRContentResourceManager.readMtrCustomResources();
    }

    private static void readNteEyecandy() {
        ResourceManagerHelper.readDirectory((String)"eyecandies", (identifier, inputStream) -> {
            if (identifier.getNamespace().equals("mtrsteamloco") && identifier.getPath().endsWith(".json")) {
                try (InputStreamReader isp = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
                    JsonObject rootObject = JSON_PARSER.parse((Reader)isp).getAsJsonObject();
                    if (rootObject.has("model")) {
                        String id = FilenameUtils.getBaseName((String)identifier.getPath());
                        ParsedScript ps = MTRContentResourceManager.tryParseScript(id, "eyecandy", "Block", rootObject, false, false);
                        eyecandyScripts.put(id, ps);
                    } else {
                        for (Map.Entry entry : rootObject.entrySet()) {
                            String id = (String)entry.getKey();
                            JsonObject entryObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                            ParsedScript ps = MTRContentResourceManager.tryParseScript(id, "eyecandy", "Block", entryObject, false, false);
                            eyecandyScripts.put(id, ps);
                        }
                    }
                }
                catch (Exception e) {
                    MTRContentResourceManager.logException("parsing NTE Eyecandy scripts", e);
                }
            }
        });
    }

    private static void readMtrCustomResources() {
        ResourceManagerHelper.readAllResources((Identifier)new Identifier("mtr", "mtr_custom_resources.json"), inputStream -> {
            try (InputStreamReader isp = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
                JsonObject scriptObject;
                ParsedScript parsedScript;
                JsonObject rootObject = JSON_PARSER.parse((Reader)isp).getAsJsonObject();
                boolean isVehicleLegacyResource = rootObject.has("custom_trains");
                JsonElement vehicleElement = isVehicleLegacyResource ? rootObject.get("custom_trains") : rootObject.get("vehicles");
                JsonElement objectsElement = rootObject.get("objects");
                if (vehicleElement != null) {
                    if (isVehicleLegacyResource) {
                        JsonObject vehicleObject = vehicleElement.getAsJsonObject();
                        for (Map.Entry map : vehicleObject.entrySet()) {
                            JsonObject vehicleResource;
                            String baseId = "mtr_custom_train_" + (String)map.getKey();
                            ParsedScript parsedScript2 = MTRContentResourceManager.tryParseScript(baseId, "vehicle", "Vehicle", vehicleResource = ((JsonElement)map.getValue()).getAsJsonObject(), false, true);
                            if (parsedScript2 == null) continue;
                            vehicleScripts.put(baseId + "_trailer", parsedScript2);
                            vehicleScripts.put(baseId + "_cab_1", parsedScript2);
                            vehicleScripts.put(baseId + "_cab_2", parsedScript2);
                            vehicleScripts.put(baseId + "_cab_3", parsedScript2);
                        }
                    } else {
                        JsonArray vehicleArray = vehicleElement.getAsJsonArray();
                        for (JsonElement vehicleEntry : vehicleArray) {
                            JsonObject vehicleObject = vehicleEntry.getAsJsonObject();
                            String baseId = vehicleObject.get("id").getAsString();
                            if (!vehicleObject.has("scripting") || (parsedScript = MTRContentResourceManager.tryParseScript(baseId, "vehicle", "Vehicle", scriptObject = vehicleObject.get("scripting").getAsJsonObject(), true, false)) == null) continue;
                            vehicleScripts.put(baseId, parsedScript);
                        }
                    }
                }
                if (objectsElement != null) {
                    JsonArray eyecandyObjects = objectsElement.getAsJsonArray();
                    for (JsonElement jsonElement : eyecandyObjects) {
                        JsonObject entryObject = jsonElement.getAsJsonObject();
                        String id = entryObject.get("id").getAsString();
                        if (!entryObject.has("scripting")) continue;
                        scriptObject = entryObject.get("scripting").getAsJsonObject();
                        try {
                            parsedScript = MTRContentResourceManager.tryParseScript(id, "eyecandy", "Block", scriptObject, true, false);
                            if (parsedScript == null) continue;
                            eyecandyScripts.put(id, parsedScript);
                        }
                        catch (Exception e) {
                            MTRContentResourceManager.logException("parsing object '" + id + "' in mtr_custom_resources.json", e);
                        }
                    }
                }
            }
            catch (Exception e) {
                MTRContentResourceManager.logException("parsing scripts in mtr_custom_resources.json", e);
            }
        });
    }

    private static ParsedScript tryParseScript(String id, String name, String contextName, JsonObject jsonObject, boolean useMtr4Naming, boolean useSnakeCase) {
        String scriptInputKey;
        String scriptFilesKey;
        ObjectArrayList scripts = new ObjectArrayList();
        String string = useMtr4Naming ? "scriptLocations" : (scriptFilesKey = useSnakeCase ? "script_files" : "scriptFiles");
        String scriptTextsKey = useMtr4Naming ? "prependExpressions" : (useSnakeCase ? "script_texts" : "scriptTexts");
        String string2 = scriptInputKey = useMtr4Naming ? "input" : "scriptInput";
        if (jsonObject.has(scriptFilesKey) || jsonObject.has(scriptTextsKey)) {
            String scriptText;
            Identifier scriptLocationSource;
            if (jsonObject.has(scriptInputKey)) {
                String str = jsonObject.get(scriptInputKey).toString();
                Identifier scriptLocationSource2 = new Identifier("mtr", "internal/script_input/" + contextName.toLowerCase() + "/" + name + "/" + id);
                scripts.add(new ScriptContent(scriptLocationSource2, "const SCRIPT_INPUT = " + str + ";"));
            }
            if (jsonObject.has(scriptTextsKey)) {
                JsonArray scriptTextArray = jsonObject.get(scriptTextsKey).getAsJsonArray();
                for (int i = 0; i < scriptTextArray.size(); ++i) {
                    scriptLocationSource = new Identifier("mtr", "internal/script_texts/" + contextName.toLowerCase() + "/" + name + "/" + id + "/line" + i);
                    scriptText = scriptTextArray.get(i).getAsString();
                    scripts.add(new ScriptContent(scriptLocationSource, scriptText));
                }
            }
            if (jsonObject.has(scriptFilesKey)) {
                JsonArray scriptFilesArray = jsonObject.get(scriptFilesKey).getAsJsonArray();
                for (int i = 0; i < scriptFilesArray.size(); ++i) {
                    scriptLocationSource = new Identifier(scriptFilesArray.get(i).getAsString());
                    scriptText = ResourceManagerHelper.readResource((Identifier)scriptLocationSource);
                    if (scriptText.isEmpty()) {
                        JCMLogger.warn("Script {}:{} is either missing, or the file content is empty!", scriptLocationSource.getNamespace(), scriptLocationSource.getPath());
                        continue;
                    }
                    scripts.add(new ScriptContent(scriptLocationSource, scriptText));
                }
            }
        }
        return scripts.isEmpty() ? null : MTRScripting.getScriptManager().parseScript(id + " (" + name + ")", contextName, (List<ScriptContent>)scripts);
    }

    public static ParsedScript getEyecandyScript(String modelId) {
        return eyecandyScripts.get(modelId);
    }

    public static ParsedScript getVehicleScript(String carriageId) {
        return vehicleScripts.get(carriageId);
    }

    private static void logException(String action, Exception e) {
        if (JCMClient.getConfig().debug) {
            JCMLogger.error("Error while " + action + "!", e);
        } else {
            JCMLogger.error("Error while " + action + ": " + e.getMessage(), new Object[0]);
            JCMLogger.error("(Enable debug mode to see more information)", new Object[0]);
        }
    }
}

