/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mixin.modded.mtr;

import com.lx862.jcm.mod.resources.MTRContentResourceManager;
import com.lx862.jcm.mod.scripting.mtr.MTRScripting;
import com.lx862.jcm.mod.scripting.mtr.vehicle.VehicleScriptContext;
import com.lx862.jcm.mod.scripting.mtr.vehicle.VehicleScriptInstance;
import com.lx862.jcm.mod.scripting.mtr.vehicle.VehicleWrapper;
import com.lx862.mtrscripting.core.ParsedScript;
import com.lx862.mtrscripting.data.UniqueKey;
import java.util.ArrayList;
import java.util.Map;
import org.mtr.core.data.VehicleCar;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.VehicleExtension;
import org.mtr.mod.render.RenderVehicles;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderVehicles.class}, remap=false)
public abstract class RenderVehiclesMixin {
    @Inject(method={"render(JLorg/mtr/mapping/holder/Vector3d;)V"}, at={@At(value="INVOKE", target="Lorg/mtr/libraries/it/unimi/dsi/fastutil/objects/ObjectArraySet;forEach(Ljava/util/function/Consumer;)V")})
    private static void renderScript(long millisElapsed, Vector3d cameraShakeOffset, CallbackInfo ci) {
        for (VehicleExtension vehicle : MinecraftClientData.getInstance().vehicles) {
            ObjectImmutableList cars = vehicle.vehicleExtraData.immutableVehicleCars;
            Object2ObjectOpenHashMap scriptsInVehicle = new Object2ObjectOpenHashMap();
            for (VehicleCar vehicleCar : cars) {
                String vehicleGroupId = MTRScripting.getVehicleGroupId(vehicleCar.getVehicleId());
                ParsedScript script = MTRContentResourceManager.getVehicleScript(vehicleGroupId);
                if (script == null || scriptsInVehicle.containsKey((Object)vehicleGroupId)) continue;
                scriptsInVehicle.put((Object)vehicleGroupId, (Object)script);
            }
            VehicleWrapper wrapperObject = new VehicleWrapper(vehicle);
            for (Map.Entry scriptEntry : scriptsInVehicle.entrySet()) {
                String vehicleGroupId = (String)scriptEntry.getKey();
                ArrayList<Integer> carsForScripts = new ArrayList<Integer>();
                for (int i2 = 0; i2 < cars.size(); ++i2) {
                    if (!MTRScripting.getVehicleGroupId(((VehicleCar)cars.get(i2)).getVehicleId()).equals(vehicleGroupId)) continue;
                    carsForScripts.add(i2);
                }
                int[] carsArray = carsForScripts.stream().mapToInt(i -> i).toArray();
                VehicleScriptInstance scriptInstance = (VehicleScriptInstance)MTRScripting.getScriptManager().getInstanceManager().getInstance(new UniqueKey("vehicle", vehicle.getHexId(), scriptEntry.getKey()), () -> new VehicleScriptInstance(new VehicleScriptContext((String)scriptEntry.getKey(), carsArray, cars.size()), vehicle, (ParsedScript)scriptEntry.getValue()));
                if (scriptInstance == null) continue;
                scriptInstance.setWrapperObject(wrapperObject);
                scriptInstance.getScript().invokeRenderFunctions(scriptInstance, () -> {
                    VehicleScriptContext ctx = (VehicleScriptContext)scriptInstance.getScriptContext();
                    scriptInstance.saveSoundCalls(ctx.getCarSoundManagers());
                    scriptInstance.saveRenderCalls(ctx.getCarRenderManager());
                    ctx.resetForNextRun();
                });
            }
        }
    }
}

