/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block.entity;

import com.lx862.jcm.mod.block.entity.JCMBlockEntityBase;
import com.lx862.jcm.mod.data.JCMServerStats;
import com.lx862.jcm.mod.registry.BlockEntities;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.DoorBlockAbstractMapping;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mapping.mapper.SoundHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;

public class AutoIronDoorBlockEntity
extends JCMBlockEntityBase {
    public static final int DETECT_RADIUS = 3;

    public AutoIronDoorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(BlockEntities.AUTO_IRON_DOOR.get(), blockPos, blockState);
    }

    public void blockEntityTick() {
        World world = this.getWorld2();
        if (world != null && !world.isClient() && JCMServerStats.getGameTick() % 5 == 0) {
            BlockPos pos = this.getPos2();
            BlockState state = world.getBlockState(pos);
            Box box = new Box((double)(pos.getX() - 3), (double)(pos.getY() - 3), (double)(pos.getZ() - 3), (double)(pos.getX() + 3), (double)(pos.getY() + 3), (double)(pos.getZ() + 3));
            AtomicBoolean haveNearbyPlayer = new AtomicBoolean(false);
            MinecraftServerHelper.iteratePlayers((ServerWorld)ServerWorld.cast((HolderBase)this.getWorld2()), player -> {
                if (box.contains(player.getPos())) {
                    boolean alreadyOpened = (Boolean)IBlock.getStatePropertySafe((BlockState)state, (Property)new Property((class_2769)DoorBlockAbstractMapping.getOpenMapped().data));
                    if (!alreadyOpened) {
                        world.playSound(null, pos, SoundHelper.createSoundEvent((Identifier)new Identifier("minecraft:block.iron_door.open")), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        world.setBlockState(pos, state.with(new Property((class_2769)DoorBlockAbstractMapping.getOpenMapped().data), (Comparable)Boolean.valueOf(true)));
                    }
                    haveNearbyPlayer.set(true);
                }
            });
            if (!haveNearbyPlayer.get() && ((Boolean)IBlock.getStatePropertySafe((BlockState)state, (Property)new Property((class_2769)DoorBlockAbstractMapping.getOpenMapped().data))).booleanValue()) {
                world.playSound((PlayerEntity)null, this.getPos2(), SoundHelper.createSoundEvent((Identifier)new Identifier("minecraft:block.iron_door.close")), SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.setBlockState(this.getPos2(), state.with(new Property((class_2769)DoorBlockAbstractMapping.getOpenMapped().data), (Comparable)Boolean.valueOf(false)));
            }
        }
    }
}

