/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.block;

import com.lx862.jcm.mod.block.entity.PIDSBlockEntity;
import com.lx862.jcm.mod.data.BlockProperties;
import com.lx862.jcm.mod.data.pids.PIDSManager;
import com.lx862.jcm.mod.data.pids.preset.PIDSPresetBase;
import com.lx862.jcm.mod.render.block.JCMBlockEntityRenderer;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.ArrivalsCacheClient;
import org.mtr.mod.render.StoredMatrixTransformations;

public abstract class PIDSRenderer<T extends PIDSBlockEntity>
extends JCMBlockEntityRenderer<T> {
    public PIDSRenderer(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void renderCurated(T blockEntity, GraphicsHolder graphicsHolder, World world, BlockState state, BlockPos pos, float tickDelta, int light, int i1) {
        LongImmutableList platforms;
        PIDSPresetBase pidsPreset = this.getPreset((PIDSBlockEntity)((Object)blockEntity));
        if (pidsPreset == null) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)BlockProperties.FACING);
        boolean[] rowHidden = new boolean[((PIDSBlockEntity)((Object)blockEntity)).getRowAmount()];
        boolean[] beRowHidden = ((PIDSBlockEntity)((Object)blockEntity)).getRowHidden();
        for (int i = 0; i < rowHidden.length; ++i) {
            rowHidden[i] = pidsPreset.isRowHidden(i) || beRowHidden[i];
        }
        if (!((PIDSBlockEntity)((Object)blockEntity)).getPlatformIds().isEmpty()) {
            platforms = new LongImmutableList((LongCollection)((PIDSBlockEntity)((Object)blockEntity)).getPlatformIds());
        } else {
            LongArrayList closestPlatforms = new LongArrayList();
            InitClient.findClosePlatform((BlockPos)pos, (int)5, e -> closestPlatforms.add(e.getId()));
            platforms = new LongImmutableList((LongList)closestPlatforms);
        }
        ObjectArrayList arrivals = ArrivalsCacheClient.INSTANCE.requestArrivals((LongCollection)platforms);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)blockEntity.getPos2().getX(), 0.5 + (double)blockEntity.getPos2().getY(), 0.5 + (double)blockEntity.getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(90.0f - facing.asRotation());
            graphicsHolderNew.rotateZDegrees(180.0f);
        });
        this.renderPIDS(blockEntity, pidsPreset, graphicsHolder, storedMatrixTransformations, world, state, pos, facing, (ObjectArrayList<ArrivalResponse>)arrivals, tickDelta, rowHidden);
    }

    public abstract void renderPIDS(T var1, PIDSPresetBase var2, GraphicsHolder var3, StoredMatrixTransformations var4, World var5, BlockState var6, BlockPos var7, Direction var8, ObjectArrayList<ArrivalResponse> var9, float var10, boolean[] var11);

    private PIDSPresetBase getPreset(PIDSBlockEntity blockEntity) {
        return PIDSManager.getPreset(blockEntity.getPresetId(), PIDSManager.getPreset(blockEntity.getDefaultPresetId()));
    }
}

