/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.text;

import com.lx862.jcm.mod.render.text.TextInfo;
import javax.annotation.Nonnull;

public class TextSlot
implements Comparable<TextSlot> {
    private static final long EXPIRE_TIME = 500L;
    private final int startX;
    private TextInfo text = null;
    private int startY;
    private long lastAccessTime = System.currentTimeMillis();
    private int width;
    private int height = 64;

    public TextSlot(int startX, int startY) {
        this.startX = startX;
        this.startY = startY;
    }

    public boolean unused() {
        return this.text == null;
    }

    public boolean reusable() {
        return System.currentTimeMillis() - this.lastAccessTime > 500L;
    }

    public TextInfo getText() {
        return this.text;
    }

    public void accessedNow() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public int getPixelWidth() {
        return this.width;
    }

    public float getMaxWidth() {
        return this.text.getWidthInfo().getMaxWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public double getRenderedWidth() {
        return this.text.getWidthInfo().clampWidth(this.getPhysicalWidth());
    }

    public double getPhysicalWidth() {
        return (double)this.width / 64.0 * 9.0;
    }

    public void setContent(TextInfo text, int textWidth, int textHeight) {
        this.text = text;
        this.lastAccessTime = System.currentTimeMillis();
        this.width = textWidth;
        this.height = textHeight;
        this.startY = this.startY - 64 + this.height;
    }

    public boolean isHoldingText(TextInfo text) {
        if (this.text == null || text == null) {
            return false;
        }
        return this.text.equals(text);
    }

    @Override
    public int compareTo(@Nonnull TextSlot o) {
        return (int)(this.lastAccessTime - o.lastAccessTime);
    }
}

