/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.scripting.jcm.pids;

import java.util.ArrayList;
import java.util.List;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Route;
import org.mtr.core.data.SimplifiedRoute;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.core.operation.CarDetails;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.ArrivalsCacheClient;

public class ArrivalWrapper {
    public final ArrivalResponse arrivalResponse;
    private final List<CarDetails> cars;

    public ArrivalWrapper(ArrivalResponse arrivalResponse) {
        this.arrivalResponse = arrivalResponse;
        this.cars = new ArrayList<CarDetails>();
        arrivalResponse.iterateCarDetails(this.cars::add);
    }

    public String destination() {
        return this.arrivalResponse.getDestination();
    }

    public long arrivalTime() {
        return this.arrivalResponse.getArrival() - ArrivalsCacheClient.INSTANCE.getMillisOffset();
    }

    public boolean arrived() {
        return this.arrivalTime() <= System.currentTimeMillis();
    }

    public long departureTime() {
        return this.arrivalResponse.getDeparture() - ArrivalsCacheClient.INSTANCE.getMillisOffset();
    }

    public boolean departed() {
        return this.departureTime() <= System.currentTimeMillis();
    }

    public long deviation() {
        return this.arrivalResponse.getDeviation();
    }

    public boolean realtime() {
        return this.arrivalResponse.getRealtime();
    }

    public long departureIndex() {
        return this.arrivalResponse.getDepartureIndex();
    }

    public boolean terminating() {
        return this.arrivalResponse.getIsTerminating();
    }

    public SimplifiedRoute route() {
        for (SimplifiedRoute route : MinecraftClientData.getInstance().simplifiedRoutes) {
            if (route.getId() != this.routeId()) continue;
            return route;
        }
        return null;
    }

    public long routeId() {
        return this.arrivalResponse.getRouteId();
    }

    public String routeName() {
        return this.arrivalResponse.getRouteName();
    }

    public String routeNumber() {
        return this.arrivalResponse.getRouteNumber();
    }

    public int routeColor() {
        return this.arrivalResponse.getRouteColor();
    }

    public Route.CircularState circularState() {
        return this.arrivalResponse.getCircularState();
    }

    public Platform platform() {
        return (Platform)MinecraftClientData.getInstance().platformIdMap.get(this.platformId());
    }

    public long platformId() {
        return this.arrivalResponse.getPlatformId();
    }

    public String platformName() {
        return this.arrivalResponse.getPlatformName();
    }

    public int carCount() {
        return this.arrivalResponse.getCarCount();
    }

    public List<CarDetails> cars() {
        return this.cars;
    }
}

