/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.scripting.jcm.pids;

import com.lx862.jcm.mod.scripting.jcm.pids.PIDSDrawCall;
import com.lx862.jcm.mod.util.TextUtil;
import java.util.ArrayList;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Style;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.InitClient;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class TextWrapper
extends PIDSDrawCall<TextWrapper> {
    public String str;
    public Identifier fontId = new Identifier("mtr", "mtr");
    public boolean shadow;
    public boolean styleItalic;
    public boolean styleBold;
    public double scale = 1.0;
    public int overflowMode;
    public int alignment = -1;
    public int color;

    protected TextWrapper() {
        super(100.0, 25.0);
    }

    public static TextWrapper create() {
        return new TextWrapper();
    }

    public static TextWrapper create(String comment) {
        return TextWrapper.create();
    }

    public TextWrapper text(String str) {
        this.str = str;
        return this;
    }

    public TextWrapper scale(double i) {
        this.scale = i;
        return this;
    }

    public TextWrapper leftAlign() {
        this.alignment = -1;
        return this;
    }

    public TextWrapper centerAlign() {
        this.alignment = 0;
        return this;
    }

    public TextWrapper rightAlign() {
        this.alignment = 1;
        return this;
    }

    public TextWrapper shadowed() {
        this.shadow = true;
        return this;
    }

    public TextWrapper stretchXY() {
        this.overflowMode = 1;
        return this;
    }

    public TextWrapper scaleXY() {
        this.overflowMode = 2;
        return this;
    }

    public TextWrapper wrapText() {
        this.overflowMode = 3;
        return this;
    }

    public TextWrapper marquee() {
        this.overflowMode = 4;
        return this;
    }

    public TextWrapper fontMC() {
        this.fontId = null;
        return this;
    }

    public TextWrapper font(String fontId) {
        return this.font(new Identifier(fontId));
    }

    public TextWrapper font(Identifier fontId) {
        this.fontId = fontId;
        return this;
    }

    public TextWrapper italic() {
        this.styleItalic = true;
        return this;
    }

    public TextWrapper bold() {
        this.styleBold = true;
        return this;
    }

    public TextWrapper color(int color) {
        this.color = color;
        return this;
    }

    @Override
    public void validate() {
        if (this.str == null) {
            throw new IllegalArgumentException("Text must be filled");
        }
    }

    @Override
    protected void drawTransformed(GraphicsHolder graphicsHolder, StoredMatrixTransformations storedMatrixTransformations, Direction facing) {
        MainRenderer.scheduleRender((QueuedRenderLayer)QueuedRenderLayer.TEXT, (graphicsHolderNew, offset) -> {
            storedMatrixTransformations.transform(graphicsHolderNew, offset);
            graphicsHolderNew.scale((float)this.scale, (float)this.scale, (float)this.scale);
            ArrayList<MutableText> texts = new ArrayList<MutableText>();
            MutableText originalText = this.getFormattedText(this.str);
            int actualW = GraphicsHolder.getTextWidth((MutableText)originalText);
            int actualH = 9;
            if (this.overflowMode == 1) {
                if ((double)actualW > this.w) {
                    graphicsHolderNew.scale((float)(this.w / (double)actualW), 1.0f, 1.0f);
                }
                if ((double)actualH > this.h) {
                    graphicsHolderNew.scale(1.0f, (float)(this.h / (double)actualH), 1.0f);
                }
            } else if (this.overflowMode == 2) {
                double minScale = Math.min((double)actualW > this.w ? this.w / (double)actualW : 1.0, (double)actualH > this.h ? this.h / (double)actualH : 1.0);
                graphicsHolderNew.translate(0.0, (this.h - (double)actualH * minScale) / 2.0, 0.0);
                graphicsHolderNew.scale((float)minScale, (float)minScale, 0.0f);
            }
            if (this.overflowMode == 3) {
                StringBuilder curLine = new StringBuilder();
                int wSoFar = 0;
                for (int i = 0; i < this.str.length(); ++i) {
                    char c = this.str.charAt(i);
                    if ((double)(wSoFar += GraphicsHolder.getTextWidth((String)String.valueOf(c))) > this.w) {
                        texts.add(this.getFormattedText(curLine.toString()));
                        curLine = new StringBuilder(String.valueOf(c));
                        wSoFar = 0;
                        continue;
                    }
                    curLine.append(c);
                }
                if (curLine.length() > 0) {
                    texts.add(this.getFormattedText(curLine.toString()));
                }
            } else {
                texts.add(this.getFormattedText(this.str));
            }
            if (this.overflowMode == 4 && (double)actualW > this.w) {
                this.drawMarqueeText((GraphicsHolder)graphicsHolderNew, ((MutableText)texts.get(0)).getString(), this.color, this.shadow, 0xF000F0);
            } else {
                int i = 0;
                for (MutableText text : texts) {
                    this.drawText((GraphicsHolder)graphicsHolderNew, text, i * 9, this.color, this.shadow, 0xF000F0);
                    ++i;
                }
            }
            graphicsHolderNew.pop();
        });
    }

    private void drawText(GraphicsHolder graphicsHolder, MutableText text, int y, int color, boolean shadow, int light) {
        int startX = 0;
        int totalW = GraphicsHolder.getTextWidth((MutableText)text);
        if (this.alignment == 0) {
            startX -= totalW / 2;
        } else if (this.alignment == 1) {
            startX -= totalW;
        }
        graphicsHolder.drawText(text, startX, y, color, shadow, light);
    }

    private void drawMarqueeText(GraphicsHolder graphicsHolder, String str, int color, boolean shadow, int light) {
        int[] textWidths = new int[str.length()];
        double textWidth = 0.0;
        for (int i = 0; i < str.length(); ++i) {
            String st = String.valueOf(str.charAt(i));
            MutableText tx = this.getFormattedText(st);
            int n = i;
            textWidths[n] = textWidths[n] + GraphicsHolder.getTextWidth((MutableText)tx);
            textWidth += (double)textWidths[i];
        }
        int fullWidth = (int)(textWidth + (double)((int)this.w));
        int cycleDuration = str.length() * 10;
        double marqueeProgress = InitClient.getGameTick() % (float)cycleDuration / (float)cycleDuration;
        double wSoFar = this.w - (double)fullWidth * marqueeProgress;
        for (int i = 0; i < str.length(); ++i) {
            String st = String.valueOf(str.charAt(i));
            MutableText tx = this.getFormattedText(st);
            if (wSoFar >= 0.0 && wSoFar <= this.w) {
                graphicsHolder.push();
                graphicsHolder.translate(wSoFar, 0.0, 0.0);
                graphicsHolder.drawText(tx, 0, 0, color, shadow, light);
                graphicsHolder.pop();
            }
            wSoFar += (double)textWidths[i];
        }
    }

    private MutableText getFormattedText(String str) {
        Style fontStyle = this.fontId != null ? TextUtil.withFontStyle(this.fontId).withBold(Boolean.valueOf(this.styleBold)).withItalic(Boolean.valueOf(this.styleItalic)) : Style.getEmptyMapped().withBold(Boolean.valueOf(this.styleBold)).withItalic(Boolean.valueOf(this.styleItalic));
        return TextHelper.setStyle((MutableText)TextHelper.literal((String)str), (Style)fontStyle);
    }
}

