/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.scripting.mtr.sound;

import com.lx862.jcm.mod.scripting.mtr.sound.NonPositionedSoundCall;
import com.lx862.jcm.mod.scripting.mtr.sound.PositionedSoundCall;
import com.lx862.jcm.mod.scripting.mtr.sound.SoundCall;
import com.lx862.mtrscripting.util.ScriptVector3f;
import java.util.ArrayList;
import java.util.List;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;

public class ScriptSoundManager {
    public final List<SoundCall> soundCalls = new ArrayList<SoundCall>();

    public ScriptSoundManager() {
    }

    private ScriptSoundManager(List<SoundCall> soundCalls) {
        this.soundCalls.addAll(soundCalls);
    }

    public void playLocalSound(Identifier id, float volume, float pitch) {
        this.queue(new NonPositionedSoundCall(id, volume, pitch));
    }

    public void playSound(Identifier id, ScriptVector3f pos, float volume, float pitch) {
        this.queue(new PositionedSoundCall(id, pos.x(), pos.y(), pos.z(), volume, pitch));
    }

    public void queue(SoundCall soundCall) {
        soundCall.validate();
        this.soundCalls.add(soundCall);
    }

    public void invoke(World world, ScriptVector3f basePos) {
        for (SoundCall soundCall : new ArrayList<SoundCall>(this.soundCalls)) {
            soundCall.run(world, basePos);
        }
    }

    public ScriptSoundManager copy() {
        return new ScriptSoundManager(this.soundCalls);
    }

    public void reset() {
        this.soundCalls.clear();
    }
}

