/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.scripting.mtr.vehicle;

import com.lx862.jcm.mod.scripting.mtr.MTRScriptContext;
import com.lx862.jcm.mod.scripting.mtr.render.ModelDrawCall;
import com.lx862.jcm.mod.scripting.mtr.render.ScriptRenderManager;
import com.lx862.jcm.mod.scripting.mtr.sound.ScriptSoundManager;
import com.lx862.jcm.mod.scripting.mtr.util.ScriptedModel;
import com.lx862.mtrscripting.util.Matrices;
import com.lx862.mtrscripting.util.ScriptVector3f;
import org.apache.commons.lang3.NotImplementedException;
import org.mtr.mapping.holder.Identifier;

public class VehicleScriptContext
extends MTRScriptContext {
    private final ScriptRenderManager[] carRenderers;
    private final ScriptSoundManager[] carSoundManagers;
    private final int[] myCars;
    private final String vehicleGroupId;

    @Override
    public void resetForNextRun() {
        for (ScriptRenderManager rm : this.carRenderers) {
            rm.reset();
        }
        for (ScriptSoundManager sm : this.carSoundManagers) {
            sm.reset();
        }
    }

    public VehicleScriptContext(String vehicleGroupId, int[] myCars, int carLength) {
        super(vehicleGroupId);
        this.myCars = myCars;
        this.vehicleGroupId = vehicleGroupId;
        this.carRenderers = new ScriptRenderManager[carLength];
        this.carSoundManagers = new ScriptSoundManager[carLength];
        for (int i : myCars) {
            this.carRenderers[i] = new ScriptRenderManager();
            this.carSoundManagers[i] = new ScriptSoundManager();
        }
    }

    public void drawCarModel(ScriptedModel model, int carIndex, Matrices matrices) {
        if (this.carRenderers[carIndex] == null) {
            return;
        }
        ModelDrawCall modelDrawCall = ((ModelDrawCall)ModelDrawCall.create().matrices(matrices == null ? null : matrices.copy())).modelObject(model);
        this.carRenderers[carIndex].drawCalls.add(modelDrawCall);
    }

    public void drawConnModel(ScriptedModel model, int carIndex, Matrices matrices) {
        throw new NotImplementedException("Not implemented");
    }

    public void playCarSound(Identifier sound, int carIndex, float x, float y, float z, float volume, float pitch) {
        if (this.carSoundManagers[carIndex] == null) {
            return;
        }
        this.carSoundManagers[carIndex].playSound(sound, new ScriptVector3f(x, y, z), volume, pitch);
    }

    public void playAnnSound(Identifier sound, float volume, float pitch) {
        if (this.carSoundManagers[0] == null) {
            return;
        }
        this.carSoundManagers[0].playLocalSound(sound, volume, pitch);
    }

    public String vehicleGroupId() {
        return this.vehicleGroupId;
    }

    public int[] myCars() {
        return this.myCars;
    }

    public ScriptRenderManager[] getCarRenderManager() {
        return this.carRenderers;
    }

    public ScriptSoundManager[] getCarSoundManagers() {
        return this.carSoundManagers;
    }
}

