/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.lib.org.mozilla.javascript;

import com.lx862.mtrscripting.lib.org.mozilla.javascript.Callable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Function;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.IdFunctionObject;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeArray;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.RegExpProxy;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptRuntime;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptRuntimeES6;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptableObject;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Undefined;
import java.io.Serializable;
import java.util.Comparator;

public class ArrayLikeAbstractOperations {
    private static final Comparator<Object> STRING_COMPARATOR = new StringLikeComparator();
    private static final Comparator<Object> DEFAULT_COMPARATOR = new ElementComparator();

    public static Object iterativeMethod(Context cx, IterativeOperation operation, Scriptable scope, Scriptable thisObj, Object[] args) {
        return ArrayLikeAbstractOperations.iterativeMethod(cx, null, operation, scope, thisObj, args, true);
    }

    public static Object iterativeMethod(Context cx, IdFunctionObject fun, IterativeOperation operation, Scriptable scope, Scriptable thisObj, Object[] args) {
        return ArrayLikeAbstractOperations.iterativeMethod(cx, fun, operation, scope, thisObj, args, false);
    }

    private static Object iterativeMethod(Context cx, IdFunctionObject fun, IterativeOperation operation, Scriptable scope, Scriptable thisObj, Object[] args, boolean skipCoercibleCheck) {
        Scriptable o = ScriptRuntime.toObject(cx, scope, thisObj);
        if (!(skipCoercibleCheck || IterativeOperation.FIND != operation && IterativeOperation.FIND_INDEX != operation && IterativeOperation.FIND_LAST != operation && IterativeOperation.FIND_LAST_INDEX != operation)) {
            ScriptRuntimeES6.requireObjectCoercible(cx, o, fun);
        }
        long length = NativeArray.getLengthProperty(cx, o);
        if (operation == IterativeOperation.MAP && length > Integer.MAX_VALUE) {
            String msg = ScriptRuntime.getMessageById("msg.arraylength.bad", new Object[0]);
            throw ScriptRuntime.rangeError(msg);
        }
        Object callbackArg = args.length > 0 ? args[0] : Undefined.instance;
        Function f = ArrayLikeAbstractOperations.getCallbackArg(cx, callbackArg);
        Scriptable parent = ScriptableObject.getTopLevelScope(f);
        Scriptable thisArg = args.length < 2 || args[1] == null || args[1] == Undefined.instance ? parent : ScriptRuntime.toObject(cx, scope, args[1]);
        Scriptable array = null;
        if (operation == IterativeOperation.FILTER || operation == IterativeOperation.MAP) {
            int resultLength = operation == IterativeOperation.MAP ? (int)length : 0;
            array = cx.newArray(scope, resultLength);
        }
        long j = 0L;
        long start = operation == IterativeOperation.FIND_LAST || operation == IterativeOperation.FIND_LAST_INDEX ? length - 1L : 0L;
        long end = operation == IterativeOperation.FIND_LAST || operation == IterativeOperation.FIND_LAST_INDEX ? -1L : length;
        long increment = operation == IterativeOperation.FIND_LAST || operation == IterativeOperation.FIND_LAST_INDEX ? -1L : 1L;
        block15: for (long i = start; i != end; i += increment) {
            Object[] innerArgs = new Object[3];
            Object elem = ArrayLikeAbstractOperations.getRawElem(o, i);
            if (elem == Scriptable.NOT_FOUND) {
                if (operation != IterativeOperation.FIND && operation != IterativeOperation.FIND_INDEX && operation != IterativeOperation.FIND_LAST && operation != IterativeOperation.FIND_LAST_INDEX) continue;
                elem = Undefined.instance;
            }
            innerArgs[0] = elem;
            innerArgs[1] = i;
            innerArgs[2] = o;
            Object result = f.call(cx, parent, thisArg, innerArgs);
            switch (operation.ordinal()) {
                case 0: {
                    if (ScriptRuntime.toBoolean(result)) continue block15;
                    return Boolean.FALSE;
                }
                case 1: {
                    if (!ScriptRuntime.toBoolean(result)) continue block15;
                    ArrayLikeAbstractOperations.defineElem(cx, array, j++, innerArgs[0]);
                    continue block15;
                }
                case 2: {
                    continue block15;
                }
                case 3: {
                    ArrayLikeAbstractOperations.defineElem(cx, array, i, result);
                    continue block15;
                }
                case 4: {
                    if (!ScriptRuntime.toBoolean(result)) continue block15;
                    return Boolean.TRUE;
                }
                case 5: 
                case 7: {
                    if (!ScriptRuntime.toBoolean(result)) continue block15;
                    return elem;
                }
                case 6: 
                case 8: {
                    if (!ScriptRuntime.toBoolean(result)) continue block15;
                    return ScriptRuntime.wrapNumber(i);
                }
            }
        }
        switch (operation.ordinal()) {
            case 0: {
                return Boolean.TRUE;
            }
            case 1: 
            case 3: {
                return array;
            }
            case 4: {
                return Boolean.FALSE;
            }
            case 6: 
            case 8: {
                return ScriptRuntime.wrapNumber(-1.0);
            }
        }
        return Undefined.instance;
    }

    static Function getCallbackArg(Context cx, Object callbackArg) {
        RegExpProxy reProxy;
        if (!(callbackArg instanceof Function)) {
            throw ScriptRuntime.notFunctionError(callbackArg);
        }
        Function f = (Function)callbackArg;
        if (cx.getLanguageVersion() >= 200 && (reProxy = ScriptRuntime.getRegExpProxy(cx)) != null && reProxy.isRegExp(f)) {
            throw ScriptRuntime.notFunctionError(callbackArg);
        }
        return f;
    }

    static void defineElem(Context cx, Scriptable target, long index, Object value) {
        if (index > Integer.MAX_VALUE) {
            String id = Long.toString(index);
            target.put(id, target, value);
        } else {
            target.put((int)index, target, value);
        }
    }

    static Object getRawElem(Scriptable target, long index) {
        if (index > Integer.MAX_VALUE) {
            return ScriptableObject.getProperty(target, Long.toString(index));
        }
        return ScriptableObject.getProperty(target, (int)index);
    }

    public static long toSliceIndex(double value, long length) {
        long result = value < 0.0 ? (value + (double)length < 0.0 ? 0L : (long)(value + (double)length)) : (value > (double)length ? length : (long)value);
        return result;
    }

    public static Object reduceMethod(Context cx, ReduceOperation operation, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object callbackArg;
        Scriptable o = ScriptRuntime.toObject(cx, scope, thisObj);
        long length = NativeArray.getLengthProperty(cx, o);
        Object object = callbackArg = args.length > 0 ? args[0] : Undefined.instance;
        if (callbackArg == null || !(callbackArg instanceof Function)) {
            throw ScriptRuntime.notFunctionError(callbackArg);
        }
        Function f = (Function)callbackArg;
        Scriptable parent = ScriptableObject.getTopLevelScope(f);
        boolean movingLeft = operation == ReduceOperation.REDUCE;
        Object value = args.length > 1 ? args[1] : Scriptable.NOT_FOUND;
        for (long i = 0L; i < length; ++i) {
            long index = movingLeft ? i : length - 1L - i;
            Object elem = ArrayLikeAbstractOperations.getRawElem(o, index);
            if (elem == Scriptable.NOT_FOUND) continue;
            if (value == Scriptable.NOT_FOUND) {
                value = elem;
                continue;
            }
            Object[] innerArgs = new Object[]{value, elem, index, o};
            value = f.call(cx, parent, parent, innerArgs);
        }
        if (value == Scriptable.NOT_FOUND) {
            throw ScriptRuntime.typeErrorById("msg.empty.array.reduce", new Object[0]);
        }
        return value;
    }

    public static Comparator<Object> getSortComparator(Context cx, Scriptable scope, Object[] args) {
        if (args.length > 0 && Undefined.instance != args[0]) {
            return ArrayLikeAbstractOperations.getSortComparatorFromArguments(cx, scope, args);
        }
        return DEFAULT_COMPARATOR;
    }

    public static ElementComparator getSortComparatorFromArguments(final Context cx, final Scriptable scope, Object[] args) {
        final Callable jsCompareFunction = ScriptRuntime.getValueFunctionAndThis(args[0], cx);
        final Scriptable funThis = ScriptRuntime.lastStoredScriptable(cx);
        final Object[] cmpBuf = new Object[2];
        return new ElementComparator(new Comparator<Object>(){

            @Override
            public int compare(Object x, Object y) {
                cmpBuf[0] = x;
                cmpBuf[1] = y;
                Object ret = jsCompareFunction.call(cx, scope, funThis, cmpBuf);
                double d = ScriptRuntime.toNumber(ret);
                int cmp = Double.compare(d, 0.0);
                if (cmp < 0) {
                    return -1;
                }
                if (cmp > 0) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public static enum IterativeOperation {
        EVERY,
        FILTER,
        FOR_EACH,
        MAP,
        SOME,
        FIND,
        FIND_INDEX,
        FIND_LAST,
        FIND_LAST_INDEX;

    }

    public static enum ReduceOperation {
        REDUCE,
        REDUCE_RIGHT;

    }

    public static final class ElementComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = -1189948017688708858L;
        private final Comparator<Object> child;

        public ElementComparator() {
            this.child = STRING_COMPARATOR;
        }

        public ElementComparator(Comparator<Object> c) {
            this.child = c;
        }

        @Override
        public int compare(Object x, Object y) {
            if (x == Undefined.instance) {
                if (y == Undefined.instance) {
                    return 0;
                }
                if (y == Scriptable.NOT_FOUND) {
                    return -1;
                }
                return 1;
            }
            if (x == Scriptable.NOT_FOUND) {
                return y == Scriptable.NOT_FOUND ? 0 : 1;
            }
            if (y == Scriptable.NOT_FOUND) {
                return -1;
            }
            if (y == Undefined.instance) {
                return -1;
            }
            return this.child.compare(x, y);
        }
    }

    public static final class StringLikeComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 5299017659728190979L;

        @Override
        public int compare(Object x, Object y) {
            String a = ScriptRuntime.toString(x);
            String b = ScriptRuntime.toString(y);
            return a.compareTo(b);
        }
    }
}

