/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.lib.org.mozilla.javascript.ast;

import com.lx862.mtrscripting.lib.org.mozilla.javascript.Node;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Token;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ast.AstNode;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ast.NodeVisitor;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ast.VariableInitializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VariableDeclaration
extends AstNode {
    private List<VariableInitializer> variables = new ArrayList<VariableInitializer>();
    private boolean isStatement;

    public VariableDeclaration() {
        this.type = 135;
    }

    public VariableDeclaration(int pos) {
        super(pos);
        this.type = 135;
    }

    public VariableDeclaration(int pos, int len) {
        super(pos, len);
        this.type = 135;
    }

    public List<VariableInitializer> getVariables() {
        return this.variables;
    }

    public void setVariables(List<VariableInitializer> variables) {
        this.assertNotNull(variables);
        this.variables.clear();
        for (VariableInitializer vi : variables) {
            this.addVariable(vi);
        }
    }

    public void addVariable(VariableInitializer v) {
        this.assertNotNull(v);
        this.variables.add(v);
        v.setParent(this);
    }

    @Override
    public Node setType(int type) {
        if (type != 135 && type != 168 && type != 167) {
            throw new IllegalArgumentException("invalid decl type: " + type);
        }
        return super.setType(type);
    }

    public boolean isVar() {
        return this.type == 135;
    }

    public boolean isConst() {
        return this.type == 168;
    }

    public boolean isLet() {
        return this.type == 167;
    }

    public boolean isStatement() {
        return this.isStatement;
    }

    public void setIsStatement(boolean isStatement) {
        this.isStatement = isStatement;
    }

    private String declTypeName() {
        return Token.typeToName(this.type).toLowerCase(Locale.ROOT);
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        sb.append(this.declTypeName());
        sb.append(" ");
        this.printList(this.variables, sb);
        if (this.isStatement()) {
            sb.append(";");
        }
        if (this.getInlineComment() != null) {
            sb.append(this.getInlineComment().toSource(depth)).append("\n");
        } else if (this.isStatement()) {
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        if (v.visit(this)) {
            for (AstNode astNode : this.variables) {
                astNode.visit(v);
            }
        }
    }
}

