/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.util;

import com.lx862.mtrscripting.core.ScriptInstance;
import org.mtr.mapping.holder.MinecraftClient;

public class TimingUtil {
    private static double totalRunningTime = 0.0;
    private double timeElapsedForScript = 0.0;
    private double frameDeltaForScript = 0.0;

    public static void update(double elapsed) {
        totalRunningTime += MinecraftClient.getInstance().isPaused() ? 0.0 : elapsed / 1000.0;
    }

    public void prepareForScript(ScriptInstance<?> scriptInstance) {
        this.timeElapsedForScript = totalRunningTime;
        this.frameDeltaForScript = totalRunningTime - scriptInstance.lastExecuteTime;
        scriptInstance.lastExecuteTime = this.timeElapsedForScript;
    }

    public static double globalElapsed() {
        return totalRunningTime;
    }

    public double elapsed() {
        return this.timeElapsedForScript;
    }

    public double delta() {
        return this.frameDeltaForScript;
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long nanoTime() {
        return System.nanoTime();
    }
}

