/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.wrapper;

import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Style;
import org.mtr.mapping.holder.TextColor;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.mapper.TextHelper;

public class VanillaTextWrapper {
    private final MutableText impl;
    private Style style;
    private boolean skipApplyingStyle;

    public VanillaTextWrapper(MutableText impl) {
        this.impl = impl;
        this.style = Style.getEmptyMapped();
    }

    public static VanillaTextWrapper literal(String str) {
        return new VanillaTextWrapper(TextHelper.literal((String)str));
    }

    public static VanillaTextWrapper translatable(String str, Object ... placeholders) {
        return new VanillaTextWrapper(TextHelper.translatable((String)str, (Object[])placeholders));
    }

    public VanillaTextWrapper append(VanillaTextWrapper other) {
        TextHelper.append((MutableText)this.impl(), (MutableText[])new MutableText[]{other.impl()});
        this.skipApplyingStyle = true;
        return this;
    }

    public VanillaTextWrapper withBold() {
        this.style = this.style.withBold(Boolean.valueOf(true));
        return this;
    }

    public VanillaTextWrapper withItalic() {
        this.style = this.style.withItalic(Boolean.valueOf(true));
        return this;
    }

    public VanillaTextWrapper withFont(Identifier id) {
        this.style = this.style.withFont(id);
        return this;
    }

    public VanillaTextWrapper withColor(int rgb) {
        this.style = this.style.withColor(TextColor.fromRgb((int)rgb));
        return this;
    }

    public VanillaTextWrapper withColor(String colorName) {
        TextFormatting textFormatting = TextFormatting.byName((String)colorName);
        if (textFormatting == null) {
            throw new IllegalArgumentException("Color " + colorName + " is not a valid text color!");
        }
        this.style = this.style.withColor(textFormatting);
        return this;
    }

    public String getString() {
        return this.impl.getString();
    }

    public MutableText impl() {
        return this.skipApplyingStyle ? this.impl : TextHelper.setStyle((MutableText)this.impl, (Style)this.style);
    }
}

