/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.awt.Color;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.Identifier;

public class KVPair {
    private final HashMap<String, Object> map = new HashMap();

    public KVPair() {
    }

    public KVPair(JsonObject jsonObject) {
        this();
        jsonObject.entrySet().forEach(entry -> {
            Object val = null;
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                JsonPrimitive jsonPrimitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                if (jsonPrimitive.isBoolean()) {
                    val = jsonPrimitive.getAsBoolean();
                }
                if (jsonPrimitive.isNumber()) {
                    val = jsonPrimitive.getAsDouble();
                }
                if (jsonPrimitive.isString()) {
                    val = jsonPrimitive.getAsString();
                }
            } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                val = ((JsonElement)entry.getValue()).getAsJsonArray();
            } else if (((JsonElement)entry.getValue()).isJsonObject()) {
                val = ((JsonElement)entry.getValue()).getAsJsonObject();
            }
            if (val != null) {
                this.with((String)entry.getKey(), val);
            }
        });
    }

    public KVPair with(String str, Object obj) {
        this.map.put(str, obj);
        return this;
    }

    public <T> T get(String key, T fallback) {
        return (T)this.map.getOrDefault(key, fallback);
    }

    public <T> T get(String key) {
        return (T)this.map.get(key);
    }

    public int getInt(String key, int fallback) {
        Object value = this.get(key);
        if (Integer.class.isInstance(value)) {
            return (Integer)value;
        }
        return ((Double)value).intValue();
    }

    public double getDouble(String key, double fallback) {
        return this.get(key, fallback);
    }

    public int getColor(String key, int defaultColor) {
        if (!this.map.containsKey(key)) {
            return defaultColor;
        }
        Object obj = this.map.get(key);
        if (obj instanceof String) {
            return Color.decode((String)obj).getRGB();
        }
        return this.getInt(key, defaultColor);
    }

    @Nullable
    public Identifier getIdentifier(String str) {
        return this.map.containsKey(str) ? new Identifier((String)this.map.get(str)) : null;
    }
}

