/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block.entity;

import com.lx862.jcm.mod.block.OperatorButtonBlock;
import com.lx862.jcm.mod.block.entity.JCMBlockEntityBase;
import com.lx862.jcm.mod.registry.BlockEntities;
import java.util.Objects;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemStack;

public class OperatorButtonBlockEntity
extends JCMBlockEntityBase {
    private boolean[] keyRequirements = new boolean[OperatorButtonBlock.ACCEPTED_KEYS.length];

    public OperatorButtonBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(BlockEntities.OPERATOR_BUTTON.get(), blockPos, blockState);
        for (int i = 0; i < OperatorButtonBlock.ACCEPTED_KEYS.length; ++i) {
            this.keyRequirements[i] = true;
        }
    }

    public void readCompoundTag(CompoundTag compoundTag) {
        super.readCompoundTag(compoundTag);
        for (int i = 0; i < OperatorButtonBlock.ACCEPTED_KEYS.length; ++i) {
            boolean isEnabled;
            this.keyRequirements[i] = isEnabled = !compoundTag.contains("required_key" + i) || compoundTag.getBoolean("required_key" + i);
        }
    }

    public void writeCompoundTag(CompoundTag compoundTag) {
        super.writeCompoundTag(compoundTag);
        for (int i = 0; i < OperatorButtonBlock.ACCEPTED_KEYS.length; ++i) {
            compoundTag.putBoolean("required_key" + i, this.keyRequirements[i]);
        }
    }

    public void setData(boolean[] keyRequirements) {
        this.keyRequirements = keyRequirements;
        this.markDirty2();
    }

    public boolean[] getKeyRequirements() {
        return this.keyRequirements;
    }

    public boolean canOpen(ItemStack itemStack) {
        for (int i = 0; i < OperatorButtonBlock.ACCEPTED_KEYS.length; ++i) {
            if (!Objects.equals(OperatorButtonBlock.ACCEPTED_KEYS[i].get().data, itemStack.getItem().data)) continue;
            return this.keyRequirements[i];
        }
        return false;
    }
}

