/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lx862.jcm.mod.data.TransactionEntry;
import com.lx862.jcm.mod.util.JCMLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.WorldSavePath;

public class TransactionLog {
    public static final int MAX_ENTRY_LIMIT = 50;

    public static void writeLog(PlayerEntity player, TransactionEntry entry) {
        Path savePath = TransactionLog.getSavePath(player);
        savePath.getParent().toFile().mkdirs();
        JsonObject jsonObject = new JsonObject();
        JsonArray entryArray = new JsonArray();
        try {
            if (Files.exists(savePath, new LinkOption[0])) {
                jsonObject = new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(savePath))).getAsJsonObject();
                entryArray = jsonObject.getAsJsonArray("entries");
            }
            entryArray.add((JsonElement)entry.toJson());
            if (entryArray.size() > 50) {
                entryArray.remove(0);
            }
            jsonObject.add("entries", (JsonElement)entryArray);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Files.write(savePath, gson.toJson((JsonElement)jsonObject).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            JCMLogger.error("Error saving data to JSON file: {}", e.getMessage());
        }
    }

    public static List<TransactionEntry> readLog(PlayerEntity player, String playerName) {
        Path savePath = TransactionLog.getSavePath(player);
        savePath.getParent().toFile().mkdirs();
        ArrayList<TransactionEntry> entries = new ArrayList<TransactionEntry>();
        try {
            if (Files.exists(savePath, new LinkOption[0])) {
                JsonObject jsonObject = new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(savePath))).getAsJsonObject();
                JsonArray playerDataArray = jsonObject.getAsJsonArray("entries");
                for (JsonElement element : playerDataArray) {
                    entries.add(TransactionEntry.fromJson(element.getAsJsonObject()));
                }
            }
        }
        catch (IOException e) {
            JCMLogger.error("Error reading data from JSON file: {}", e.getMessage());
        }
        return entries;
    }

    public static Path getSavePath(PlayerEntity player) {
        Path saveDirectory = player.getServer().getSavePath(WorldSavePath.getRootMapped()).resolve("jsblock").resolve("player_data");
        saveDirectory.toFile().mkdirs();
        return saveDirectory.resolve(player.getUuidAsString() + ".json");
    }
}

