/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.lib.org.mozilla.javascript.commonjs.module.provider;

import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.commonjs.module.ModuleScript;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;

public abstract class CachingModuleScriptProviderBase
implements ModuleScriptProvider,
Serializable {
    private static final long serialVersionUID = -1L;
    private static final int loadConcurrencyLevel;
    private static final int loadLockShift;
    private static final int loadLockMask;
    private static final int loadLockCount;
    private final Object[] loadLocks = new Object[loadLockCount];
    private final ModuleSourceProvider moduleSourceProvider;

    protected CachingModuleScriptProviderBase(ModuleSourceProvider moduleSourceProvider) {
        for (int i = 0; i < this.loadLocks.length; ++i) {
            this.loadLocks[i] = new Object();
        }
        this.moduleSourceProvider = moduleSourceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleScript getModuleScript(Context cx, String moduleId, URI moduleUri, URI baseUri, Scriptable paths) throws Exception {
        ModuleSource moduleSource;
        CachedModuleScript cachedModule1 = this.getLoadedModule(moduleId);
        Object validator1 = CachingModuleScriptProviderBase.getValidator(cachedModule1);
        ModuleSource moduleSource2 = moduleSource = moduleUri == null ? this.moduleSourceProvider.loadSource(moduleId, paths, validator1) : this.moduleSourceProvider.loadSource(moduleUri, baseUri, validator1);
        if (moduleSource == ModuleSourceProvider.NOT_MODIFIED) {
            return cachedModule1.getModule();
        }
        if (moduleSource == null) {
            return null;
        }
        try (Reader reader = moduleSource.getReader();){
            int idHash = moduleId.hashCode();
            Object object = this.loadLocks[idHash >>> loadLockShift & loadLockMask];
            synchronized (object) {
                CachedModuleScript cachedModule2 = this.getLoadedModule(moduleId);
                if (cachedModule2 != null && !CachingModuleScriptProviderBase.equal(validator1, CachingModuleScriptProviderBase.getValidator(cachedModule2))) {
                    ModuleScript moduleScript = cachedModule2.getModule();
                    return moduleScript;
                }
                URI sourceUri = moduleSource.getUri();
                ModuleScript moduleScript = new ModuleScript(cx.compileReader(reader, sourceUri.toString(), 1, moduleSource.getSecurityDomain()), sourceUri, moduleSource.getBase());
                this.putLoadedModule(moduleId, moduleScript, moduleSource.getValidator());
                ModuleScript moduleScript2 = moduleScript;
                return moduleScript2;
            }
        }
    }

    protected abstract void putLoadedModule(String var1, ModuleScript var2, Object var3);

    protected abstract CachedModuleScript getLoadedModule(String var1);

    private static Object getValidator(CachedModuleScript cachedModule) {
        return cachedModule == null ? null : cachedModule.getValidator();
    }

    private static boolean equal(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected static int getConcurrencyLevel() {
        return loadLockCount;
    }

    static {
        int ssize;
        loadConcurrencyLevel = Runtime.getRuntime().availableProcessors() * 8;
        int sshift = 0;
        for (ssize = 1; ssize < loadConcurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        loadLockShift = 32 - sshift;
        loadLockMask = ssize - 1;
        loadLockCount = ssize;
    }

    public static class CachedModuleScript {
        private final ModuleScript moduleScript;
        private final Object validator;

        public CachedModuleScript(ModuleScript moduleScript, Object validator) {
            this.moduleScript = moduleScript;
            this.validator = validator;
        }

        ModuleScript getModule() {
            return this.moduleScript;
        }

        Object getValidator() {
            return this.validator;
        }
    }
}

