/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.registry;

import com.lx862.jcm.mod.Constants;
import com.lx862.jcm.mod.registry.BlockEntities;
import com.lx862.jcm.mod.registry.Blocks;
import com.lx862.jcm.mod.registry.Events;
import com.lx862.jcm.mod.registry.Items;
import com.lx862.jcm.mod.registry.Networking;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.registry.BlockEntityTypeRegistryObject;
import org.mtr.mapping.registry.BlockRegistryObject;
import org.mtr.mapping.registry.CreativeModeTabHolder;
import org.mtr.mapping.registry.ItemRegistryObject;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.registry.Registry;
import org.mtr.mapping.tool.PacketBufferReceiver;

public class JCMRegistry {
    public static final Registry REGISTRY = new Registry();

    public static BlockRegistryObject registerBlockItem(String id, Supplier<Block> supplier, CreativeModeTabHolder itemGroup) {
        return REGISTRY.registerBlockWithBlockItem(Constants.id(id), supplier, new CreativeModeTabHolder[]{itemGroup});
    }

    public static BlockRegistryObject registerBlock(String id, Supplier<Block> supplier) {
        return REGISTRY.registerBlock(Constants.id(id), supplier);
    }

    public static ItemRegistryObject registerItem(String id, Function<ItemSettings, Item> callback, CreativeModeTabHolder itemGroup) {
        return REGISTRY.registerItem(Constants.id(id), callback, new CreativeModeTabHolder[]{itemGroup});
    }

    public static <T extends BlockEntityExtension> BlockEntityTypeRegistryObject<T> registerBlockEntity(String id, BiFunction<BlockPos, BlockState, T> constructor, BlockRegistryObject associatedBlock) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((BlockRegistryObject)associatedBlock).get();
        return REGISTRY.registerBlockEntityType(Constants.id(id), constructor, supplierArray);
    }

    public static void setupPacket() {
        REGISTRY.setupPackets(Constants.id("packet"));
    }

    public static <T extends PacketHandler> void registerPacket(Class<T> classObject, Function<PacketBufferReceiver, T> getInstance) {
        REGISTRY.registerPacket(classObject, getInstance);
    }

    public static void register() {
        Blocks.register();
        BlockEntities.register();
        Items.register();
        Events.register();
        Networking.register();
        REGISTRY.init();
    }
}

