/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.lib.org.mozilla.javascript.typedarrays;

import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.LambdaConstructor;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptRuntime;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptRuntimeES6;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptableObject;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Undefined;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.typedarrays.ByteIo;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeFloat64Array
extends NativeTypedArrayView<Double> {
    private static final long serialVersionUID = -1255405650050639335L;
    private static final String CLASS_NAME = "Float64Array";
    private static final int BYTES_PER_ELEMENT = 8;

    public NativeFloat64Array() {
    }

    public NativeFloat64Array(NativeArrayBuffer ab, int off, int len) {
        super(ab, off, len, len * 8);
    }

    public NativeFloat64Array(int len) {
        this(new NativeArrayBuffer((double)len * 8.0), 0, len);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 3, 2, (lcx, lscope, args) -> NativeTypedArrayView.js_constructor(lcx, lscope, args, NativeFloat64Array::new, 8));
        constructor.setPrototypePropertyAttributes(7);
        NativeTypedArrayView.init(cx, scope, constructor, NativeFloat64Array::realThis);
        constructor.defineProperty("BYTES_PER_ELEMENT", (Object)8, 7);
        constructor.definePrototypeProperty("BYTES_PER_ELEMENT", (Object)8, 7);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        ScriptableObject.defineProperty(scope, CLASS_NAME, constructor, 2);
        if (sealed) {
            constructor.sealObject();
        }
    }

    @Override
    public int getBytesPerElement() {
        return 8;
    }

    private static NativeFloat64Array realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeFloat64Array.class);
    }

    @Override
    protected Object js_get(int index) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        long base = ByteIo.readUint64Primitive(this.arrayBuffer.buffer, index * 8 + this.offset, NativeFloat64Array.useLittleEndian());
        return Double.longBitsToDouble(base);
    }

    @Override
    protected Object js_set(int index, Object c) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        double val = ScriptRuntime.toNumber(c);
        long base = Double.doubleToLongBits(val);
        ByteIo.writeUint64(this.arrayBuffer.buffer, index * 8 + this.offset, base, NativeFloat64Array.useLittleEndian());
        return null;
    }

    @Override
    public Double get(int i) {
        if (this.checkIndex(i)) {
            throw new IndexOutOfBoundsException();
        }
        return (Double)this.js_get(i);
    }

    @Override
    public Double set(int i, Double aByte) {
        if (this.checkIndex(i)) {
            throw new IndexOutOfBoundsException();
        }
        return (Double)this.js_set(i, aByte);
    }
}

