/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block;

import com.lx862.jcm.mod.block.base.WallAttachedBlock;
import com.lx862.jcm.mod.block.entity.OperatorButtonBlockEntity;
import com.lx862.jcm.mod.data.BlockProperties;
import com.lx862.jcm.mod.network.gui.OperatorButtonGUIPacket;
import com.lx862.jcm.mod.registry.Networking;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import java.util.List;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.registry.ItemRegistryObject;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Items;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.item.ItemDepotDriverKey;
import org.mtr.mod.item.ItemDriverKey;

public class OperatorButtonBlock
extends WallAttachedBlock
implements BlockWithEntity {
    public static final ItemRegistryObject[] ACCEPTED_KEYS = new ItemRegistryObject[]{Items.BASIC_DRIVER_KEY, Items.GUARD_KEY, Items.ADVANCED_DRIVER_KEY, Items.CREATIVE_DRIVER_KEY};
    public static final BooleanProperty POWERED = BlockProperties.POWERED;
    private final int poweredDuration;

    public OperatorButtonBlock(BlockSettings settings, int poweredDuration) {
        super(settings);
        this.setDefaultState2(this.getDefaultState2().with(new Property((net.minecraft.state.Property)OperatorButtonBlock.POWERED.data), (Comparable)Boolean.valueOf(false)));
        this.poweredDuration = poweredDuration;
    }

    public VoxelShape getOutlineShape2(BlockState state, BlockView view, BlockPos pos, ShapeContext context) {
        return IBlock.getVoxelShapeByDirection((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.5, (double)0.2, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
    }

    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        if (world.isClient()) {
            return ActionResult.SUCCESS;
        }
        BlockEntity thisBE = world.getBlockEntity(pos);
        OperatorButtonBlockEntity be = thisBE == null ? null : (OperatorButtonBlockEntity)((Object)thisBE.data);
        IBlock.checkHoldingBrush((World)world, (PlayerEntity)player, () -> Networking.sendPacketToClient(player, new OperatorButtonGUIPacket(pos, be.getKeyRequirements())), () -> {
            ItemStack[] itemStacks;
            boolean pass = false;
            for (ItemStack stack : itemStacks = new ItemStack[]{player.getMainHandStack(), player.getOffHandStack()}) {
                if (be == null) {
                    if (stack.getItem().data instanceof ItemDriverKey) {
                        pass = true;
                    }
                } else if (be.canOpen(stack)) {
                    pass = true;
                }
                if (stack.getItem().data instanceof ItemDepotDriverKey && stack.getOrCreateTag().getLong("expiry_time") < System.currentTimeMillis()) {
                    pass = false;
                }
                if (pass) break;
            }
            if (pass) {
                this.setPowered(world, state, pos, true);
                OperatorButtonBlock.scheduleBlockTick((World)world, (BlockPos)pos, (Block)new Block((net.minecraft.block.Block)this), (int)this.poweredDuration);
            } else {
                player.sendMessage(Text.cast((HolderBase)TextUtil.translatable(TextCategory.HUD, "operator_button.fail", new Object[0]).formatted(TextFormatting.RED)), true);
            }
        });
        return ActionResult.SUCCESS;
    }

    public void scheduledTick2(BlockState state, ServerWorld serverWorld, BlockPos pos, Random random) {
        if (((Boolean)state.get(new Property((net.minecraft.state.Property)OperatorButtonBlock.POWERED.data))).booleanValue()) {
            this.setPowered(World.cast((HolderBase)serverWorld), state, pos, false);
        }
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add((HolderBase<?>)POWERED);
    }

    public boolean emitsRedstonePower2(BlockState state) {
        return true;
    }

    public int getWeakRedstonePower2(BlockState state, BlockView world, BlockPos pos, Direction direction) {
        return IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)POWERED) ? 15 : 0;
    }

    public int getStrongRedstonePower2(BlockState state, BlockView world, BlockPos pos, Direction direction) {
        return IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)POWERED) ? 15 : 0;
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new OperatorButtonBlockEntity(blockPos, blockState);
    }

    private void setPowered(World world, BlockState blockState, BlockPos pos, boolean powered) {
        world.setBlockState(pos, blockState.with(new Property((net.minecraft.state.Property)OperatorButtonBlock.POWERED.data), (Comparable)Boolean.valueOf(powered)));
        this.updateNearbyBlock(world, pos, Direction.convert((net.minecraft.util.Direction)((net.minecraft.util.Direction)blockState.get(new Property((net.minecraft.state.Property)OperatorButtonBlock.FACING.data)))));
    }

    private void updateNearbyBlock(World world, BlockPos pos, Direction blockFacing) {
        world.updateNeighbors(pos.offset(blockFacing), new Block((net.minecraft.block.Block)this));
    }
}

