/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen;

import com.lx862.jcm.mod.block.entity.PIDSBlockEntity;
import com.lx862.jcm.mod.data.pids.PIDSManager;
import com.lx862.jcm.mod.data.pids.preset.PIDSPresetBase;
import com.lx862.jcm.mod.render.GuiHelper;
import com.lx862.jcm.mod.render.RenderHelper;
import com.lx862.jcm.mod.render.gui.screen.base.TitledScreen;
import com.lx862.jcm.mod.render.gui.widget.ContentItem;
import com.lx862.jcm.mod.render.gui.widget.HorizontalWidgetSet;
import com.lx862.jcm.mod.render.gui.widget.ListViewWidget;
import com.lx862.jcm.mod.render.gui.widget.MappedWidget;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import java.util.function.Consumer;
import net.minecraft.client.gui.widget.Widget;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mapping.tool.TextCase;

public class PIDSPresetScreen
extends TitledScreen
implements RenderHelper,
GuiHelper {
    private static final Identifier PIDS_PREVIEW_BASE = new Identifier("jsblock:textures/gui/pids_preview.png");
    private final TextFieldWidgetExtension searchBox;
    private final ListViewWidget listViewWidget;
    private final Consumer<String> callback;
    private final String selectedPreset;
    private final String pidsType;

    public PIDSPresetScreen(BlockPos pos, String selectedPreset, Consumer<String> callback) {
        super(false);
        BlockEntity be = MinecraftClient.getInstance().getWorldMapped().getBlockEntity(pos);
        this.pidsType = be != null && be.data instanceof PIDSBlockEntity ? ((PIDSBlockEntity)((Object)be.data)).getPIDSType() : "";
        this.selectedPreset = selectedPreset;
        this.callback = callback;
        this.listViewWidget = new ListViewWidget();
        this.searchBox = new TextFieldWidgetExtension(0, 0, 0, 22, 60, TextCase.DEFAULT, null, TextUtil.translatable(TextCategory.GUI, "widget.search", new Object[0]).getString());
    }

    protected void init2() {
        super.init2();
        int contentWidth = (int)Math.min((double)this.field_230708_k_ * 0.75, 400.0);
        int listViewHeight = (int)((double)(this.field_230709_l_ - 60) * 0.76);
        int startX = (this.field_230708_k_ - contentWidth) / 2;
        int searchStartY = 50;
        int startY = searchStartY + 30;
        this.listViewWidget.reset();
        this.addConfigEntries();
        this.searchBox.setX2(startX);
        this.searchBox.setY2(searchStartY);
        this.searchBox.setWidth2(contentWidth);
        this.searchBox.setChangedListener2(this.listViewWidget::setSearchTerm);
        this.searchBox.setText2(this.searchBox.getText2());
        this.listViewWidget.setXYSize(startX, startY, contentWidth, listViewHeight);
        this.addChild(new ClickableWidget((Widget)this.listViewWidget));
        this.addChild(new ClickableWidget((Widget)this.searchBox));
    }

    @Override
    public MutableText getScreenTitle() {
        return TextUtil.translatable(TextCategory.GUI, "pids_preset.title", new Object[0]);
    }

    @Override
    public MutableText getScreenSubtitle() {
        return TextUtil.translatable(TextCategory.GUI, "pids_preset.subtitle", this.selectedPreset);
    }

    public void addConfigEntries() {
        this.listViewWidget.addCategory(TextUtil.translatable(TextCategory.GUI, "pids_preset.listview.category.builtin", new Object[0]));
        for (PIDSPresetBase preset : PIDSManager.getBuiltInPresets()) {
            this.addPreset(preset);
        }
        if (!PIDSManager.getCustomPresets().isEmpty()) {
            this.listViewWidget.addCategory(TextUtil.translatable(TextCategory.GUI, "pids_preset.listview.category.custom", new Object[0]));
            for (PIDSPresetBase preset : PIDSManager.getCustomPresets()) {
                this.addPreset(preset);
            }
        }
    }

    private void addPreset(PIDSPresetBase preset) {
        if (!preset.typeAllowed(this.pidsType)) {
            return;
        }
        ButtonWidgetExtension selectBtn = new ButtonWidgetExtension(0, 0, 60, 20, TextUtil.translatable(TextCategory.GUI, "pids_preset.listview.widget.choose", new Object[0]), btn -> this.choose(preset.getId()));
        if (preset.getId().equals(this.selectedPreset)) {
            selectBtn.setMessage2(Text.cast((HolderBase)TextUtil.translatable(TextCategory.GUI, "pids_preset.listview.widget.selected", new Object[0])));
            selectBtn.field_230693_o_ = false;
        }
        HorizontalWidgetSet widgetSet = new HorizontalWidgetSet();
        widgetSet.addWidget(new MappedWidget(selectBtn));
        widgetSet.setXYSize(0, 0, 100, 20);
        this.addChild(new ClickableWidget((Widget)selectBtn));
        this.addChild(new ClickableWidget((Widget)widgetSet));
        ContentItem contentItem = new ContentItem(TextUtil.literal(preset.getName()), new MappedWidget(widgetSet), 26);
        contentItem.setIconCallback((guiDrawing, startX, startY, width, height) -> PIDSPresetScreen.drawPIDSPreview(preset, guiDrawing, startX, startY, width, height, false));
        this.listViewWidget.add(contentItem);
    }

    public static void drawPIDSPreview(PIDSPresetBase preset, GuiDrawing guiDrawing, int startX, int startY, int width, int height, boolean backgroundOnly) {
        int offset = 6;
        GuiHelper.drawTexture(guiDrawing, PIDS_PREVIEW_BASE, startX, startY, width, height);
        if (preset == null) {
            return;
        }
        GuiHelper.drawTexture(guiDrawing, preset.getThumbnail(), (double)startX + 0.5, (double)(startY + 6) + 0.5, width - 1, height - 6 - 4);
        if (!backgroundOnly) {
            double perRow = (double)height / 8.5;
            double rowHeight = Math.max(0.5, (double)height / 24.0);
            for (int i = 0; i < 4; ++i) {
                if (preset.isRowHidden(i)) continue;
                double curY = (double)(startY + 6) + (double)(i + 1) * perRow;
                GuiHelper.drawRectangle(guiDrawing, (double)startX + 1.5, curY, (double)width * 0.55, rowHeight, preset.getTextColor());
                GuiHelper.drawRectangle(guiDrawing, (double)startX + (double)width * 0.65, curY, rowHeight, rowHeight, preset.getTextColor());
                GuiHelper.drawRectangle(guiDrawing, (double)startX + (double)width * 0.75, curY, (double)width * 0.2 - 0.5, rowHeight, preset.getTextColor());
            }
        }
    }

    private void choose(String id) {
        this.callback.accept(id);
        this.onClose2();
    }

    public boolean isPauseScreen2() {
        return false;
    }
}

