/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.scripting.mtr;

import com.lx862.jcm.mod.JCMClient;
import com.lx862.jcm.mod.render.gui.ScriptDebugOverlay;
import com.lx862.jcm.mod.scripting.mtr.render.DisplayHelperCompat;
import com.lx862.jcm.mod.scripting.mtr.render.ModelDrawCall;
import com.lx862.jcm.mod.scripting.mtr.render.QuadDrawCall;
import com.lx862.jcm.mod.scripting.mtr.util.ModelManager;
import com.lx862.jcm.mod.scripting.mtr.util.TextUtil;
import com.lx862.jcm.mod.util.JCMLogger;
import com.lx862.mtrscripting.ScriptManager;
import com.lx862.mtrscripting.api.ClassRule;
import com.lx862.mtrscripting.api.ScriptingAPI;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeJavaClass;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.util.TriConsumer;
import org.mtr.mod.Keys;
import org.mtr.mod.client.MinecraftClientData;

public class MTRScripting {
    public static ExecutorService scriptThread = Executors.newFixedThreadPool(4);
    private static ScriptManager scriptManager;

    public static void register() {
        if (scriptManager == null) {
            scriptManager = new ScriptManager(scriptThread);
        }
        scriptManager.getClassShutter().setEnabled(!JCMClient.getConfig().disableScriptingRestriction);
        String mtrModVersion = null;
        try {
            mtrModVersion = (String)Keys.class.getField("MOD_VERSION").get(null);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        ScriptingAPI.registerAddonVersion("mtr", mtrModVersion);
        ScriptDebugOverlay.registerDebugSource("MTR", scriptManager);
        scriptManager.getClassShutter().allowClass(ClassRule.parse("org.mtr.*"));
        scriptManager.getClassShutter().allowClass(ClassRule.parse("com.lx862.jcm.mod.scripting.mtr.*"));
        scriptManager.onParseScript((TriConsumer<String, Context, Scriptable>)((TriConsumer)(contextName, context, scriptable) -> {
            scriptable.put("ModelDrawCall", (Scriptable)scriptable, (Object)new NativeJavaClass((Scriptable)scriptable, ModelDrawCall.class));
            scriptable.put("QuadDrawCall", (Scriptable)scriptable, (Object)new NativeJavaClass((Scriptable)scriptable, QuadDrawCall.class));
            scriptable.put("MTRClientData", (Scriptable)scriptable, (Object)new NativeJavaClass((Scriptable)scriptable, MinecraftClientData.class));
            scriptable.put("TextUtil", (Scriptable)scriptable, (Object)new NativeJavaClass((Scriptable)scriptable, TextUtil.class));
            scriptable.put("DisplayHelperCompat", (Scriptable)scriptable, (Object)new NativeJavaClass((Scriptable)scriptable, DisplayHelperCompat.class));
            scriptable.put("ModelManager", (Scriptable)scriptable, (Object)new NativeJavaClass((Scriptable)scriptable, ModelManager.class));
        }));
    }

    public static ScriptManager getScriptManager() {
        return scriptManager;
    }

    public static void tick() {
        int clearedInstance = scriptManager.getInstanceManager().clearDeadInstance();
        if (clearedInstance > 0 && JCMClient.getConfig().debug) {
            JCMLogger.info("Removed {} dead MTR script instance", clearedInstance);
        }
    }

    public static void reset() {
        scriptManager.reset();
    }
}

