/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block;

import com.lx862.jcm.mod.block.base.JCMBlock;
import com.lx862.jcm.mod.data.BlockProperties;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import java.util.List;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;

public class LightBlock
extends JCMBlock {
    public static final IntegerProperty LIGHT_LEVEL = BlockProperties.LIGHT_LEVEL;

    public LightBlock(BlockSettings settings) {
        super(settings);
        this.setDefaultState2(this.getDefaultState2().with(new Property((net.minecraft.state.Property)LightBlock.LIGHT_LEVEL.data), (Comparable)Integer.valueOf(15)));
    }

    public void randomDisplayTick2(BlockState state, World world, BlockPos pos, Random random) {
        ClientPlayerEntity player = MinecraftClient.getInstance().getPlayerMapped();
        if (player == null || player.isHolding(this.asItem2())) {
            // empty if block
        }
    }

    public VoxelShape getOutlineShape2(BlockState state, BlockView view, BlockPos pos, ShapeContext context) {
        return VoxelShapes.fullCube();
    }

    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext shapeContext) {
        return VoxelShapes.empty();
    }

    public boolean isTranslucent2(BlockState state, BlockView world, BlockPos pos) {
        return true;
    }

    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        if (world.isClient()) {
            return ActionResult.SUCCESS;
        }
        if (player.isHolding(this.asItem2())) {
            BlockState newState = state.cycle(new Property((net.minecraft.state.Property)LightBlock.LIGHT_LEVEL.data));
            world.setBlockState(pos, newState);
            player.sendMessage(Text.cast((HolderBase)TextUtil.translatable(TextCategory.HUD, "light_block.success", IBlock.getStatePropertySafe((BlockState)newState, (Property)new Property((net.minecraft.state.Property)LightBlock.LIGHT_LEVEL.data)))), true);
            return ActionResult.SUCCESS;
        }
        return ActionResult.FAIL;
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add((HolderBase<?>)LIGHT_LEVEL);
    }
}

