/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen;

import com.lx862.jcm.mod.block.OperatorButtonBlock;
import com.lx862.jcm.mod.network.block.OperatorButtonUpdatePacket;
import com.lx862.jcm.mod.registry.Blocks;
import com.lx862.jcm.mod.registry.Networking;
import com.lx862.jcm.mod.render.GuiHelper;
import com.lx862.jcm.mod.render.gui.screen.base.BlockConfigScreen;
import com.lx862.jcm.mod.render.gui.widget.WidgetSet;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.gui.widget.Widget;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PressAction;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.ColorHelper;
import org.mtr.mod.item.ItemDriverKey;

public class OperatorButtonScreen
extends BlockConfigScreen {
    private static final int KEY_BUTTON_SIZE = 50;
    private final boolean[] keyRequirements;
    private KeyToggleButton hoveredButton = null;

    public OperatorButtonScreen(BlockPos blockPos, boolean[] keyRequirements) {
        super(blockPos);
        this.keyRequirements = keyRequirements;
    }

    public void init2() {
        super.init2();
        int centerX = this.getWidthMapped() / 2;
        int contentWidth = this.getContentWidth();
        int startX = (this.field_230708_k_ - contentWidth) / 2;
        int startY = (int)((float)this.getHeightMapped() / 2.5f);
        int keyRowWidth = 50 * OperatorButtonBlock.ACCEPTED_KEYS.length + (OperatorButtonBlock.ACCEPTED_KEYS.length - 1) * 10;
        WidgetSet keyRow = new WidgetSet(50, 10);
        int i = 0;
        while (i < OperatorButtonBlock.ACCEPTED_KEYS.length) {
            int keyIdx = i++;
            KeyToggleButton keyToggleButton = new KeyToggleButton((ItemDriverKey)OperatorButtonBlock.ACCEPTED_KEYS[keyIdx].get().data, this.keyRequirements[keyIdx], itm -> {
                this.hoveredButton = itm;
            }, 0, 0, 50, 50, btn -> {
                this.keyRequirements[keyIdx] = ((KeyToggleButton)((Object)((Object)btn.data))).isAllowed();
            });
            keyRow.addWidget(keyToggleButton);
            this.addChild(new ClickableWidget((Widget)keyToggleButton));
        }
        keyRow.setXYSize(centerX - keyRowWidth / 2, startY - 25, keyRowWidth, 50);
        this.addChild(new ClickableWidget((Widget)keyRow));
        this.addBottomRowEntry(startX, this.getHeightMapped() - 40, contentWidth, 40);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        super.render(graphicsHolder, mouseX, mouseY, delta);
        int startY = (int)((float)this.getHeightMapped() / 2.5f);
        MutableText allowedKeyText = TextUtil.translatable(TextCategory.GUI, "operator_button.keys_title", new Object[0]).formatted(TextFormatting.UNDERLINE);
        graphicsHolder.push();
        graphicsHolder.translate((double)this.getWidthMapped() / 2.0, (double)(startY - 45), 0.0);
        graphicsHolder.scale(1.5f, 1.5f, 1.5f);
        graphicsHolder.drawCenteredText(allowedKeyText, 0, 0, -1);
        graphicsHolder.pop();
        if (this.hoveredButton != null) {
            ItemDriverKey key = this.hoveredButton.getKeyItem();
            MutableText itemText = TextUtil.translatable(key.getTranslationKey2(), new Object[0]);
            MutableText prefixTick = TextUtil.literal("\u2714 ").formatted(TextFormatting.DARK_GREEN);
            MutableText prefixCross = TextUtil.literal("\u2717 ").formatted(TextFormatting.DARK_RED);
            graphicsHolder.push();
            graphicsHolder.translate((double)this.getWidthMapped() / 2.0, (double)(startY + 40), 0.0);
            graphicsHolder.translate(0.0, 0.0, 0.0);
            graphicsHolder.scale(1.5f, 1.5f, 1.5f);
            graphicsHolder.drawCenteredText(TextHelper.append((MutableText)(this.hoveredButton.isAllowed() ? prefixTick : prefixCross), (MutableText[])new MutableText[]{itemText.formatted(TextFormatting.WHITE)}), 0, 0, key.color);
            graphicsHolder.pop();
            graphicsHolder.push();
            graphicsHolder.translate((double)this.getWidthMapped() / 2.0, (double)(startY + 60), 0.0);
            MutableText canDrive = TextHelper.append((MutableText)TextUtil.translatable(TextCategory.GUI, "operator_button.key.drivable", new Object[0]).formatted(TextFormatting.YELLOW), (MutableText[])new MutableText[]{this.getBooleanText(key.canDrive)});
            graphicsHolder.drawCenteredText(canDrive, 0, 0, -1);
            graphicsHolder.translate(0.0, 10.0, 0.0);
            MutableText canOpenDoor = TextHelper.append((MutableText)TextUtil.translatable(TextCategory.GUI, "operator_button.key.door", new Object[0]).formatted(TextFormatting.YELLOW), (MutableText[])new MutableText[]{this.getBooleanText(key.canOpenDoors)});
            graphicsHolder.drawCenteredText(canOpenDoor, 0, 0, -1);
            graphicsHolder.translate(0.0, 10.0, 0.0);
            MutableText canBoardVehicles = TextHelper.append((MutableText)TextUtil.translatable(TextCategory.GUI, "operator_button.key.board", new Object[0]).formatted(TextFormatting.YELLOW), (MutableText[])new MutableText[]{this.getBooleanText(key.canBoardAnyVehicle)});
            graphicsHolder.drawCenteredText(canBoardVehicles, 0, 0, -1);
            graphicsHolder.pop();
        }
    }

    @Override
    public MutableText getScreenTitle() {
        return Blocks.OPERATOR_BUTTON.get().getName();
    }

    @Override
    protected void onSave() {
        Networking.sendPacketToServer(new OperatorButtonUpdatePacket(this.blockPos, this.keyRequirements));
    }

    private MutableText getBooleanText(boolean bl) {
        MutableText text = TextUtil.translatable(bl ? "gui.yes" : "gui.no", new Object[0]);
        return text.formatted(bl ? TextFormatting.GREEN : TextFormatting.RED);
    }

    static class KeyToggleButton
    extends ButtonWidgetExtension {
        private static final Identifier KEY_TEXTURE = new Identifier("mtr:textures/item/driver_key.png");
        private static final int BORDER_PADDING = 8;
        private static final int SELECTED_COLOR = -16711936;
        private static final int DESELECTED_COLOR = -65536;
        private final ItemDriverKey keyItem;
        private final Consumer<KeyToggleButton> hoverCallback;
        private boolean allowed;
        private boolean lastHovered;

        public KeyToggleButton(ItemDriverKey keyItem, boolean allowed, Consumer<KeyToggleButton> hoverCallback, int x, int y, int width, int height, PressAction onPress) {
            super(x, y, width, height, onPress);
            this.keyItem = keyItem;
            this.hoverCallback = hoverCallback;
            this.allowed = allowed;
        }

        public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
            super.render(graphicsHolder, mouseX, mouseY, delta);
            if (this.field_230694_p_) {
                GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
                ColorHelper.unpackColor((int)(0xFF000000 | this.keyItem.color), (a, r, g, b) -> {
                    RenderSystem.color4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
                    GuiHelper.drawTexture(guiDrawing, KEY_TEXTURE, this.getX2() + 8, this.getY2() + 8, this.getWidth2() - 16, this.getHeight2() - 16);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                });
                int borderColor = this.allowed ? -16711936 : -65536;
                GuiHelper.drawRectangle(guiDrawing, this.getX2(), this.getY2(), this.getWidth2(), 1.0, borderColor);
                GuiHelper.drawRectangle(guiDrawing, this.getX2(), this.getY2() + this.getHeight2() - 1, this.getWidth2(), 1.0, borderColor);
                GuiHelper.drawRectangle(guiDrawing, this.getX2(), this.getY2(), 1.0, this.getHeight2(), borderColor);
                GuiHelper.drawRectangle(guiDrawing, this.getX2() + this.getWidth2() - 1, this.getY2(), 1.0, this.getHeight2(), borderColor);
                if (this.lastHovered != this.func_230449_g_()) {
                    this.hoverCallback.accept(this.func_230449_g_() ? this : null);
                    this.lastHovered = this.func_230449_g_();
                }
            }
        }

        public void onPress2() {
            this.allowed = !this.allowed;
            super.onPress2();
        }

        public ItemDriverKey getKeyItem() {
            return this.keyItem;
        }

        public boolean isAllowed() {
            return this.allowed;
        }
    }
}

