/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen;

import com.lx862.jcm.mod.render.GuiHelper;
import com.lx862.jcm.mod.render.RenderHelper;
import com.lx862.jcm.mod.render.gui.screen.base.TitledScreen;
import com.lx862.jcm.mod.render.text.TextureTextRenderer;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import net.minecraft.client.gui.widget.Widget;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public class TextureTextAtlasScreen
extends TitledScreen
implements RenderHelper,
GuiHelper {
    public TextureTextAtlasScreen() {
        super(true);
    }

    @Override
    public MutableText getScreenTitle() {
        return TextUtil.literal("New Text Renderer");
    }

    @Override
    public MutableText getScreenSubtitle() {
        return TextUtil.literal("Viewing texture atlas");
    }

    protected void init2() {
        super.init2();
        int btnWidth = GuiHelper.getButtonWidth((double)this.field_230708_k_ * 0.6);
        ButtonWidgetExtension btn = new ButtonWidgetExtension((this.field_230708_k_ - btnWidth) / 2, this.field_230709_l_ - 30, btnWidth, 20, TextUtil.translatable("gui.done", new Object[0]), b -> this.onClose2());
        this.addChild(new ClickableWidget((Widget)btn));
    }

    @Override
    public void drawBackground(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        super.drawBackground(graphicsHolder, mouseX, mouseY, tickDelta);
        this.drawTextureAtlas(graphicsHolder, new GuiDrawing(graphicsHolder));
    }

    private void drawTextureAtlas(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing) {
        int maxWidth = (int)((double)this.field_230708_k_ * 0.75);
        int maxHeight = this.field_230709_l_ - 90;
        if (TextureTextRenderer.initialized()) {
            double imgRatio = (double)TextureTextRenderer.getAtlasWidth() / (double)TextureTextRenderer.getAtlasHeight();
            double finalWidth = maxWidth;
            double finalHeight = (double)maxWidth / imgRatio;
            if (finalHeight > (double)maxHeight) {
                finalWidth = (double)maxHeight * imgRatio;
                finalHeight = maxHeight;
            }
            int startX = (this.field_230708_k_ - (int)(finalWidth *= this.animationProgress)) / 2;
            int startY = (this.field_230709_l_ - (int)(finalHeight *= this.animationProgress)) / 2;
            GuiHelper.drawTexture(guiDrawing, TextureTextRenderer.getAtlasIdentifier(), startX, startY, (int)finalWidth, (int)finalHeight);
        } else {
            graphicsHolder.push();
            graphicsHolder.translate((double)this.field_230708_k_ / 2.0, (double)this.field_230709_l_ / 2.0, 0.0);
            graphicsHolder.scale((float)this.animationProgress, (float)this.animationProgress, (float)this.animationProgress);
            RenderHelper.drawCenteredText(graphicsHolder, TextUtil.translatable(TextCategory.GUI, "atlas_config.not_initialized", new Object[0]), 0, 0, -1);
            graphicsHolder.pop();
        }
    }

    public boolean isPauseScreen2() {
        return false;
    }
}

