/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.util;

import com.lx862.mtrscripting.util.TimingUtil;
import java.util.Objects;

public class StateTracker {
    private Object lastState;
    private Object currentState;
    private double currentStateTime;
    private boolean firstTimeCurrentState;

    public void setState(Object newValue) {
        if (!Objects.equals(newValue, this.currentState)) {
            this.lastState = this.currentState;
            this.currentState = newValue;
            this.currentStateTime = TimingUtil.globalElapsed();
            this.firstTimeCurrentState = true;
        } else {
            this.firstTimeCurrentState = false;
        }
    }

    public Object stateNow() {
        return this.currentState;
    }

    public Object stateLast() {
        return this.lastState;
    }

    public double stateNowDuration() {
        return TimingUtil.globalElapsed() - this.currentStateTime;
    }

    public boolean stateNowFirst() {
        return this.firstTimeCurrentState;
    }

    public boolean changedTo(Object state) {
        return this.stateNowFirst() && Objects.equals(this.currentState, state);
    }

    public boolean changedFromTo(Object oldState, Object curState) {
        return this.stateNowFirst() && Objects.equals(oldState, this.lastState) && Objects.equals(curState, this.currentState);
    }
}

