/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens.widgets;

import com.gitlab.srcmc.rctapi.api.util.Locations;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerDataWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerListWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.text.MultiStyleStringWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class TrainerInfoWidget
extends TrainerDataWidget {
    private static final int MAX_SPECIES_LENGTH = 28;
    private static final int MAX_BIOME_LENGTH = 24;
    private Consumer<Integer> backClickedHandler;
    private String trainerId;
    private int page;
    private TrainerListWidget.EntryState entryState;
    private TrainerMobData trainer;
    private int innerHeight;
    private int w;
    private int h;
    private int y;
    private List<PageContent> contents = new ArrayList<PageContent>();
    private TrainerDataWidget.HoverElement<MultiStyleStringWidget> back;
    private StringWidget number;
    private StringWidget name;
    private boolean obfuscated;
    private int ticks;

    public TrainerInfoWidget(int x, int y, int w, int h, Font font) {
        super(x, y, w, h, font);
    }

    public void tick() {
        if ((this.entryState == TrainerListWidget.EntryState.DISCOVERED_KEY || this.entryState == TrainerListWidget.EntryState.HIDDEN_KEY) && this.name != null && this.ticks % 30 == 0) {
            MutableComponent msg = this.name.getMessage().plainCopy().withStyle(ChatFormatting.GREEN);
            boolean bl = this.obfuscated = !this.obfuscated;
            if (this.obfuscated) {
                msg = msg.withStyle(ChatFormatting.OBFUSCATED);
            }
            this.name.setMessage((Component)msg);
        }
        ++this.ticks;
    }

    public void initTrainerInfo(int trainerNr, String trainerId, TrainerListWidget.EntryState entryState) {
        this.trainer = RCTMod.getInstance().getTrainerManager().getData(trainerId);
        this.trainerId = trainerId;
        this.entryState = entryState;
        this.w = (int)((float)(this.getWidth() - this.totalInnerPadding()) / 0.65f);
        this.h = this.getHeight() / 6;
        this.y = 0;
        String displayName = entryState == TrainerListWidget.EntryState.UNKNOWN ? "???" : this.trainer.getTrainerTeam().getName().getComponent(new Object[0]).getString();
        int backX = (int)((double)this.w * 0.9);
        this.back = new TrainerDataWidget.HoverElement((TrainerDataWidget)this, (Renderable)new MultiStyleStringWidget(this, backX, this.y, this.w - backX, this.h, (Component)TrainerInfoWidget.toComponent("[X]"), this.font).addStyle(Style.EMPTY.withColor(ChatFormatting.RED)).alignRight(), msw -> msw.setStyle(1), msw -> msw.setStyle(0));
        this.number = new MultiStyleStringWidget(this, 0, this.y, this.w, this.h, (Component)TrainerInfoWidget.toComponent(String.format("%04d: ", trainerNr)), this.font).alignLeft();
        this.name = new MultiStyleStringWidget(this, (int)((double)this.w * 0.18), this.y, (int)((double)this.w * 0.72), this.h, (Component)(entryState == TrainerListWidget.EntryState.HIDDEN_KEY ? TrainerInfoWidget.toComponent(displayName).withStyle(ChatFormatting.OBFUSCATED) : TrainerInfoWidget.toComponent(displayName)), this.font).scrolling().alignLeft();
        ((MultiStyleStringWidget)((Object)this.back.element)).active = true;
        this.contents.clear();
        this.contents.add(this.initOverviewPage());
        if (entryState != TrainerListWidget.EntryState.UNKNOWN) {
            this.contents.add(this.initSpawningPage());
        }
        if (entryState == TrainerListWidget.EntryState.DISCOVERED) {
            this.contents.add(this.initTeamPage());
        }
        this.setPage(0);
        this.updateInnerHeight();
    }

    private PageContent initPage(Component title) {
        return new PageContent(this, title, new Renderable[]{this.number, this.name, this.back});
    }

    private PageContent initOverviewPage() {
        PageContent pc = this.initPage((Component)Component.translatable((String)"gui.rctmod.trainer_card.overview"));
        String curSeries = PlayerState.get((Player)Minecraft.getInstance().player).getCurrentSeries();
        this.y = 0;
        pc.renderables.add((Renderable)new StringWidget(8, this.y += this.h, this.w, this.h, (Component)TrainerInfoWidget.toComponent(String.format("%s: ", Component.translatable((String)"gui.rctmod.trainer_card.type").getString())), this.font).alignLeft());
        pc.renderables.add((Renderable)new StringWidget(8, this.y, (int)((double)this.w * 0.9), this.h, (Component)TrainerInfoWidget.toComponent(this.trainer.getType().name().getComponent(new Object[0]).getString()), this.font).alignRight());
        LocalPlayer player = Minecraft.getInstance().player;
        int reqCap = this.trainer.getRequiredLevelCap((Player)player);
        int rewCap = this.trainer.getRewardLevelCap((Player)player);
        pc.renderables.add((Renderable)new StringWidget(8, this.y += this.h, this.w, this.h, (Component)TrainerInfoWidget.toComponent(String.format("%s: ", Component.translatable((String)"gui.rctmod.trainer_card.level_cap").getString())), this.font).alignLeft());
        pc.renderables.add((Renderable)new StringWidget(8, this.y, (int)((double)this.w * 0.9), this.h, (Component)TrainerInfoWidget.toComponent(String.format("%d -> %d", reqCap, Math.max(reqCap, rewCap))), this.font).alignRight());
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        boolean[] first = new boolean[]{true};
        this.trainer.getMissingRequirements(Set.of()).map(tm::getData).filter(tmd -> tmd.isOfSeries(curSeries)).sorted((tmd1, tmd2) -> {
            int c = Integer.compare(tmd1.getRequiredLevelCap((Player)player), tmd2.getRequiredLevelCap((Player)player));
            return c == 0 ? tmd1.getTrainerTeam().getName().compareTo(tmd2.getTrainerTeam().getName()) : c;
        }).forEach(tmd -> {
            if (first[0]) {
                pc.renderables.add((Renderable)new StringWidget(8, this.y += this.h, this.w, this.h, (Component)TrainerInfoWidget.toComponent(Component.translatable((String)"gui.rctmod.trainer_card.required_trainers").getString()), this.font).alignLeft());
                first[0] = false;
            }
            pc.renderables.add((Renderable)new StringWidget(16, this.y += this.h, this.w, this.h, (Component)TrainerInfoWidget.toComponent(String.format("%s", tmd.getTrainerTeam().getName())), this.font).alignLeft());
        });
        pc.height = this.y + this.h;
        return pc;
    }

    private PageContent initSpawningPage() {
        PageContent pc = this.initPage((Component)Component.translatable((String)"gui.rctmod.trainer_card.spawning"));
        Minecraft mc = Minecraft.getInstance();
        Registry reg = mc.level.registryAccess().registryOrThrow(Registries.BIOME);
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        PriorityQueue biomes = new PriorityQueue((r1, r2) -> {
            int i = r1.getNamespace().compareTo(r2.getNamespace());
            return i == 0 ? r1.getPath().compareTo(r2.getPath()) : i;
        });
        this.y = 0;
        Item sigItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.trainer.getSignatureItem()));
        if (sigItem != null && !Items.AIR.equals(sigItem)) {
            pc.renderables.add((Renderable)new StringWidget(8, this.y += this.h, this.w, this.h, (Component)TrainerInfoWidget.toComponent(Component.translatable((String)"gui.rctmod.trainer_card.signature_item")), this.font).alignLeft());
            pc.renderables.add((Renderable)new StringWidget(16, this.y += this.h, this.w, this.h, (Component)TrainerInfoWidget.toComponent(sigItem.getDefaultInstance().getHoverName().getString()), this.font).alignLeft());
        }
        pc.renderables.add((Renderable)new StringWidget(8, this.y += this.h, this.w, this.h, (Component)TrainerInfoWidget.toComponent(Component.translatable((String)"gui.rctmod.trainer_card.biomes")), this.font).alignLeft());
        reg.holders().forEach(holder -> {
            block2: {
                block4: {
                    Set tags;
                    block3: {
                        tags = holder.tags().map(t -> t.location().getNamespace() + ":" + t.location().getPath()).collect(Collectors.toSet());
                        holder.tags().map(t -> t.location().getPath()).forEach(t -> tags.add(t));
                        if (!config.biomeTagBlacklist().stream().noneMatch(tags::contains)) break block2;
                        if (!this.trainer.getBiomeTagBlacklist().stream().noneMatch(tags::contains)) break block2;
                        if (config.biomeTagWhitelist().isEmpty()) break block3;
                        if (!config.biomeTagWhitelist().stream().anyMatch(tags::contains)) break block2;
                    }
                    if (this.trainer.getBiomeTagWhitelist().isEmpty()) break block4;
                    if (!this.trainer.getBiomeTagWhitelist().stream().anyMatch(tags::contains)) break block2;
                }
                biomes.offer((ResourceLocation)holder.unwrap().map(r -> r.location(), b -> ResourceLocation.fromNamespaceAndPath((String)"[unregistered]", (String)b.toString())));
            }
        });
        String namespace = "";
        while (!biomes.isEmpty()) {
            ResourceLocation rs = (ResourceLocation)biomes.poll();
            if (!namespace.equals(rs.getNamespace())) {
                pc.renderables.add((Renderable)new StringWidget(16, this.y += this.h, this.w, this.h, (Component)TrainerInfoWidget.toComponent(TextUtils.trim(rs.getNamespace(), 24)), this.font).alignLeft());
                namespace = rs.getNamespace();
            }
            pc.renderables.add((Renderable)new StringWidget(20, this.y += this.h, this.w, this.h, (Component)TrainerInfoWidget.toComponent(TextUtils.trim(rs.getPath(), 24)), this.font).alignLeft());
        }
        pc.height = this.y + this.h;
        return pc;
    }

    private PageContent initTeamPage() {
        PageContent pc = this.initPage((Component)Component.translatable((String)"gui.rctmod.trainer_card.team"));
        this.y = 0;
        pc.height = this.y + this.h;
        this.trainer.getTrainerTeam().getTeam().forEach(poke -> {
            pc.renderables.add((Renderable)new StringWidget(8, this.y += this.h, this.w, this.h, (Component)TrainerInfoWidget.toComponent(TextUtils.trim(Locations.withoutNamespace((String)poke.getSpecies()), 28)), this.font).alignLeft());
            pc.renderables.add((Renderable)new StringWidget(8, this.y, (int)((double)this.w * 0.9), this.h, (Component)TrainerInfoWidget.toComponent(poke.getLevel()), this.font).alignRight());
        });
        return pc;
    }

    public String getTrainerId() {
        return this.trainerId;
    }

    public PageContent getPageContent(int page) {
        return this.contents.get(page);
    }

    @Override
    protected void renderPage(GuiGraphics guiGraphics, int x, int y, float f) {
        for (Renderable r : this.getPageContent((int)this.getPage()).renderables) {
            r.render(guiGraphics, x, y, f);
        }
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public int getMaxPage() {
        return this.contents.size() - 1;
    }

    @Override
    public void setPage(int page) {
        if (page != this.page) {
            this.page = Math.max(0, Math.min(this.contents.size() - 1, page));
            this.updateInnerHeight();
            this.setScrollAmount(0.0);
        }
    }

    public void setOnBackClicked(Consumer<Integer> backClickedHandler) {
        this.backClickedHandler = backClickedHandler;
    }

    @Override
    protected int getInnerHeight() {
        return (int)((float)this.innerHeight * 0.65f);
    }

    private void updateInnerHeight() {
        this.innerHeight = Math.max(this.getHeight() - this.totalInnerPadding(), this.getPageContent((int)this.getPage()).height);
    }

    public boolean mouseClicked(double x, double y, int i) {
        if (super.mouseClicked(x, y, i)) {
            if (this.backClickedHandler != null && ((MultiStyleStringWidget)((Object)this.back.element)).mouseClicked(x = this.localX(x), y = this.localY(y), i)) {
                this.backClickedHandler.accept(i);
            }
            return true;
        }
        return false;
    }

    public class PageContent {
        public final Component title;
        public final List<Renderable> renderables = new ArrayList<Renderable>();
        protected int height;

        private PageContent(TrainerInfoWidget this$0, Component title, Renderable ... renderables) {
            this.title = title;
            for (Renderable r : renderables) {
                this.renderables.add(r);
            }
        }
    }
}

