/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.utils;

import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7471;
import net.minecraft.class_7604;
import net.minecraft.server.MinecraftServer;

public final class ChatUtils {
    private static Map<String, Text[]> defaultDialog = new HashMap<String, Text[]>();

    public static void initDefault(Map<String, Text[]> defaultDialog) {
        ChatUtils.defaultDialog = defaultDialog == null ? Map.of() : defaultDialog;
    }

    public static void reply(TrainerMob source, class_1657 target, String ... contexts) {
        TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(source);
        ChatUtils.reply((class_1309)source, target, (String context) -> tmd.getDialog().get(context), contexts);
    }

    public static void reply(class_1309 source, class_1657 target, String ... contexts) {
        ChatUtils.reply(source, target, (String context) -> defaultDialog.get(context), contexts);
    }

    private static void reply(class_1309 source, class_1657 target, Function<String, Text[]> messagesFunc, String ... contexts) {
        for (String context : contexts) {
            Text[] messages = messagesFunc.apply(context);
            if (messages == null) continue;
            if (messages.length > 0) {
                class_7471 message = class_7471.method_45041((String)"").method_44863((class_2561)messages[(target.method_59922().method_43054() & Integer.MAX_VALUE) % messages.length].getComponent(new Object[0]));
                target.method_5671().method_44749(class_7604.method_44857((class_7471)message), false, class_2556.method_44832((class_5321)class_2556.field_11737, (class_1297)source));
                return;
            }
            ModCommon.LOG.warn(String.format("Empty dialog context '%s'", context));
            return;
        }
        ModCommon.LOG.warn(String.format("Invalid dialog contexts '%s'", String.valueOf(contexts)));
    }

    public static void replyRaw(class_1309 source, class_1657 target, Text text, Object ... args) {
        class_7471 message = class_7471.method_45041((String)"").method_44863((class_2561)text.getComponent(args));
        target.method_5671().method_44749(class_7604.method_44857((class_7471)message), false, class_2556.method_44832((class_5321)class_2556.field_11737, (class_1297)source));
    }

    public static void sendMessage(class_1657 target, Text text, Object ... args) {
        target.method_5671().method_45068((class_2561)text.getComponent(args));
    }

    public static void broadcastMessage(MinecraftServer server, Text text, int opLevel, Object ... args) {
        server.method_3760().method_14571().stream().filter(pl -> pl.method_5687(opLevel)).forEach(pl -> ChatUtils.sendMessage((class_1657)pl, text, args));
    }

    public static void sendError(class_1657 target, Text text, Object ... args) {
        target.method_5671().method_45068((class_2561)text.getComponent(args).method_27692(class_124.field_1061));
    }

    public static void broadcastError(MinecraftServer server, Text text, int opLevel, Object ... args) {
        server.method_3760().method_14571().stream().filter(pl -> pl.method_5687(opLevel)).forEach(pl -> ChatUtils.sendError((class_1657)pl, text, args));
    }

    public static void sendTitle(class_1657 target, Text title, Text subtitle, Object ... args) {
        try {
            class_2168 cs = target.method_5671().method_9206(2).method_9217();
            if (subtitle != null && !subtitle.isEmpty()) {
                cs.method_54310().execute(String.format("title @s subtitle %s", class_2561.class_2562.method_10867((class_2561)subtitle.getComponent(args).method_27692(class_124.field_1056), (class_7225.class_7874)target.method_56673())), (Object)cs);
            }
            if (title == null) {
                title = Text.empty();
            }
            cs.method_54310().execute(String.format("title @s title %s", class_2561.class_2562.method_10867((class_2561)title.getComponent(args), (class_7225.class_7874)target.method_56673())), (Object)cs);
        }
        catch (CommandSyntaxException e) {
            ModCommon.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void sendActionbar(class_1657 target, Text message, Object ... args) {
        try {
            class_2168 cs = target.method_5671().method_9206(2).method_9217();
            cs.method_54310().execute(String.format("title @s actionbar %s", class_2561.class_2562.method_10867((class_2561)message.getComponent(args), (class_7225.class_7874)target.method_56673())), (Object)cs);
        }
        catch (CommandSyntaxException e) {
            ModCommon.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private ChatUtils() {
    }
}

