/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3966;
import net.minecraft.class_4051;

public class ForceIntoBattleGoal
extends class_1352 {
    private static final int TIMEOUT_TICKS = 50;
    private static final float CANCEL_PROBABILITY = 0.05f;
    private static final double BB_HEIGHT = 3.0;
    private int tickOfLastAttempt;
    private int tickOfLookAt;
    private TrainerManager tm;
    private TrainerMob mob;
    private final Class<? extends class_1309> lookAtType;
    private class_1297 lookAt;

    public ForceIntoBattleGoal(TrainerMob mob, Class<? extends class_1309> clazz) {
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
        this.tm = RCTMod.getInstance().getTrainerManager();
        this.mob = mob;
        this.lookAtType = clazz;
    }

    public void method_6269() {
        this.tickOfLookAt = this.mob.field_6012;
        this.mob.method_5942().method_6340();
    }

    public boolean method_6264() {
        class_4051 lookAtContext;
        if (this.mob.method_59922().method_43057() < this.mob.getForceBattleChance() && !this.mob.isInBattle() && this.mob.getCooldown() == 0 && this.mob.field_6012 - this.tickOfLastAttempt > 50 && (lookAtContext = this.initContext()) != null) {
            if (this.mob.method_5968() != null) {
                this.lookAt = this.mob.method_5968();
            }
            if (this.lookAtType == class_1657.class) {
                this.lookAt = this.mob.method_37908().method_18463(lookAtContext, (class_1309)this.mob, this.mob.method_23317(), this.mob.method_23320(), this.mob.method_23321());
            } else {
                double d = this.mob.getForceBattleMaxDistance();
                this.lookAt = this.mob.method_37908().method_18468(this.mob.method_37908().method_8390(this.lookAtType, this.mob.method_5829().method_1009(d, 3.0, d), le -> true), lookAtContext, (class_1309)this.mob, this.mob.method_23317(), this.mob.method_23320(), this.mob.method_23321());
            }
            return this.lookAt != null;
        }
        return false;
    }

    public boolean method_6266() {
        double d = this.mob.getForceBattleMaxDistance();
        if (this.lookAt != null && this.lookAt.method_5805() && !this.mob.isInBattle() && this.mob.getCooldown() == 0 && this.mob.method_5858(this.lookAt) < d * d) {
            return true;
        }
        this.method_6270();
        return false;
    }

    public void method_6268() {
        if (this.lookAt != null && this.lookAt.method_5805()) {
            this.mob.method_5988().method_20248(this.lookAt.method_23317(), this.mob.method_23320(), this.lookAt.method_23321());
        }
        if (this.lookAt instanceof class_1657) {
            class_243 from = this.lookAt.method_33571();
            class_243 to = from.method_1019(this.lookAt.method_5663().method_1021((double)this.mob.getForceBattleMaxDistance()));
            class_3966 hit = class_1675.method_18077((class_1937)this.mob.method_37908(), (class_1297)this.lookAt, (class_243)from, (class_243)to, (class_238)class_238.method_30048((class_243)from, (double)0.15, (double)0.15, (double)0.15).method_18804(to.method_1020(from)), e -> true);
            if (hit == null || hit.method_17782() != this.mob) {
                if (this.mob.method_59922().method_43057() < 0.05f) {
                    this.tickOfLastAttempt = this.mob.field_6012;
                    this.method_6270();
                    return;
                }
                this.tickOfLookAt = this.mob.field_6012;
            }
        }
        if (this.mob.field_6012 - this.tickOfLookAt > this.mob.getForceBattleLookTicks()) {
            this.tryStartBattle();
            this.method_6270();
        }
    }

    private void tryStartBattle() {
        class_1657 player;
        class_1297 class_12972 = this.lookAt;
        if (class_12972 instanceof class_1657 && this.mob.canBattleAgainst((class_1297)(player = (class_1657)class_12972)) && this.isInLevelRange(player)) {
            this.mob.startBattleWith(player);
        }
        this.tickOfLastAttempt = this.mob.field_6012;
    }

    private class_4051 initContext() {
        return this.lookAtType == class_1657.class ? class_4051.method_36626().method_18418((double)this.mob.getForceBattleMaxDistance()).method_18420(le -> class_1301.method_5913((class_1297)this.mob).test(le)) : class_4051.method_36626().method_18418((double)this.mob.getForceBattleMaxDistance());
    }

    private boolean isInLevelRange(class_1657 player) {
        return Math.abs(this.tm.getPlayerLevel(player) - this.tm.getData(this.mob).getTrainerTeam().getTeam().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0)) <= this.mob.getForceBattleMaxLevelDiff();
    }
}

