/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.server;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.pokemon.ExperienceGainedEvent;
import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.TrainerBattle;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerBattleMemory;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerSpawner;
import com.gitlab.srcmc.rctmod.api.utils.ArrUtils;
import com.gitlab.srcmc.rctmod.api.utils.ChatUtils;
import com.gitlab.srcmc.rctmod.commands.PlayerCommands;
import com.gitlab.srcmc.rctmod.commands.TrainerCommands;
import com.gitlab.srcmc.rctmod.commands.utils.SuggestionUtils;
import com.gitlab.srcmc.rctmod.network.BatchedPayload;
import com.gitlab.srcmc.rctmod.network.BatchedPayloads;
import com.gitlab.srcmc.rctmod.network.TrainerTargetPayload;
import com.gitlab.srcmc.rctmod.world.entities.TrainerAssociation;
import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;

public class ModServer {
    private static final Map<UUID, Queue<Map.Entry<byte[], Integer>>> PLAYER_STATE_PAYLOADS = new HashMap<UUID, Queue<Map.Entry<byte[], Integer>>>();
    private static final Queue<TrainerManagerPayloadTargets> TRAINER_MANAGER_PAYLOADS = new LinkedList<TrainerManagerPayloadTargets>();
    private static final Queue<Thread> SER_THREADS = new LinkedList<Thread>();

    public static void registerEventHandlers() {
        CommandRegistrationEvent.EVENT.register(ModServer::onCommandRegistration);
        LifecycleEvent.SETUP.register(ModServer::onSetup);
        LifecycleEvent.SERVER_STARTING.register(ModServer::onServerStarting);
        LifecycleEvent.SERVER_STOPPED.register(ModServer::onServerStopped);
        LifecycleEvent.SERVER_LEVEL_SAVE.register(ModServer::onServerLevelSave);
        TickEvent.LevelTick.SERVER_LEVEL_PRE.register(ModServer::onServerWorldTick);
        TickEvent.LevelTick.SERVER_PRE.register(ModServer::onServerTick);
        PlayerEvent.PLAYER_JOIN.register(ModServer::onPlayerJoin);
        PlayerEvent.PLAYER_QUIT.register(ModServer::onPlayerQuit);
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, ModServer::onBattleVictory);
        CobblemonEvents.EXPERIENCE_GAINED_EVENT_PRE.subscribe(Priority.HIGHEST, ModServer::onExperienceGained);
    }

    public static void init() {
        NetworkManager.registerS2CPayloadType(BatchedPayloads.PLAYER_STATE.TYPE, BatchedPayloads.PLAYER_STATE.CODEC);
        NetworkManager.registerS2CPayloadType(BatchedPayloads.TRAINER_MANAGER.TYPE, BatchedPayloads.TRAINER_MANAGER.CODEC);
        NetworkManager.registerS2CPayloadType(TrainerTargetPayload.TYPE, TrainerTargetPayload.CODEC);
    }

    public static void syncTrainerManger(ServerPlayer ... players) {
        ModServer.syncTrainerManger(List.of(players));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncTrainerManger(Iterable<ServerPlayer> players) {
        LinkedList<ServerPlayer> list = new LinkedList<ServerPlayer>();
        for (ServerPlayer p : players) {
            if (p.getGameProfile() == p.getServer().getSingleplayerProfile()) continue;
            list.add(p);
        }
        if (!list.isEmpty()) {
            Thread serTh = new Thread(() -> {
                BatchedPayload.Payload[] pls = RCTMod.getInstance().getTrainerManager().toPayloads();
                ((ServerPlayer)list.getFirst()).getServer().execute(() -> {
                    for (BatchedPayload.Payload pl : pls) {
                        TRAINER_MANAGER_PAYLOADS.offer(new TrainerManagerPayloadTargets(pl.bytes(), pl.remainingBatches(), list));
                    }
                });
                Queue<Thread> queue = SER_THREADS;
                synchronized (queue) {
                    SER_THREADS.poll();
                    if (!SER_THREADS.isEmpty()) {
                        SER_THREADS.peek().start();
                    }
                }
            });
            serTh.setDaemon(true);
            serTh.setPriority(1);
            Queue<Thread> queue = SER_THREADS;
            synchronized (queue) {
                SER_THREADS.offer(serTh);
                if (SER_THREADS.size() == 1) {
                    serTh.start();
                }
            }
        }
    }

    static void onCommandRegistration(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection env) {
        PlayerCommands.register(dispatcher);
        TrainerCommands.register(dispatcher);
    }

    static void onSetup() {
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)RCTMod.getInstance().getTrainerManager());
    }

    static void onServerLevelSave(ServerLevel level) {
        if (level.getServer().overworld() == level) {
            TrainerBattleMemory.clearLegacyFiles();
        }
    }

    static void onServerStarting(MinecraftServer server) {
        PLAYER_STATE_PAYLOADS.clear();
        TRAINER_MANAGER_PAYLOADS.clear();
        RCTMod.getInstance().getTrainerSpawner().init(server.overworld());
        RCTMod.getInstance().getTrainerManager().setIsReloadedAsDatapack(true);
        RCTMod.getInstance().getTrainerManager().setServer(server);
    }

    static void onServerStopped(MinecraftServer server) {
        RCTMod.getInstance().getTrainerManager().setIsReloadedAsDatapack(false);
        RCTMod.getInstance().getTrainerManager().setServer(null);
    }

    static void onServerTick(MinecraftServer server) {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        if (server.isRunning()) {
            RCTMod.getInstance().getTrainerSpawner().checkDespawns();
            if (tm.isReloadRequired()) {
                tm.loadTrainers();
                if (TrainerBattleMemory.getVersion(server.overworld().getDataStorage()).isOutdated()) {
                    TrainerBattleMemory.migrate(server, tm);
                }
                SuggestionUtils.initSuggestions();
            }
            while (!TRAINER_MANAGER_PAYLOADS.isEmpty()) {
                TrainerManagerPayloadTargets pl = TRAINER_MANAGER_PAYLOADS.poll();
                Iterator<ServerPlayer> it = pl.players().iterator();
                while (it.hasNext()) {
                    if (!it.next().hasDisconnected()) continue;
                    it.remove();
                }
                if (!pl.players().iterator().hasNext()) continue;
                NetworkManager.sendToPlayers(pl.players(), (CustomPacketPayload)BatchedPayloads.TRAINER_MANAGER.payload(pl.bytes(), pl.remainingBatches()));
                break;
            }
        }
    }

    static void onServerWorldTick(ServerLevel level) {
        RCTMod rct = RCTMod.getInstance();
        if (!rct.getTrainerManager().isReloadRequired()) {
            IServerConfig cfg = rct.getServerConfig();
            TrainerSpawner trs = rct.getTrainerSpawner();
            level.players().stream().filter(pl -> PlayerState.get((Player)pl) != null).forEach(player -> {
                int maxCountPl = cfg.maxTrainersPerPlayer();
                if (maxCountPl > 0) {
                    int spawnCountPl = trs.getSpawnCount(player.getUUID());
                    int ticksRange = Math.max(0, cfg.spawnIntervalTicksMaximum() - cfg.spawnIntervalTicks());
                    int spawnIntervalTicks = cfg.spawnIntervalTicks() + (int)((float)ticksRange * (maxCountPl > 1 ? Math.min(1.0f, (float)spawnCountPl / (float)(maxCountPl - 1)) : 1.0f));
                    if (spawnIntervalTicks == 0 || player.tickCount % spawnIntervalTicks == 0) {
                        rct.getTrainerSpawner().attemptSpawnFor((Player)player);
                    }
                }
                if (player.tickCount % 400 == 0 && cfg.spawnTrainerAssociation()) {
                    TrainerAssociation.trySpawnFor((Player)player);
                }
                if (player.tickCount % 5 == 0) {
                    byte[] bytes = PlayerState.get((Player)player).serializeUpdate();
                    Queue payloads = PLAYER_STATE_PAYLOADS.computeIfAbsent(player.getUUID(), k -> new LinkedList());
                    if (bytes.length > 0) {
                        List<byte[]> batches = ArrUtils.split(bytes, Math.max(64, Math.min(2048, bytes.length / 5)));
                        int i = batches.size();
                        for (byte[] batch : batches) {
                            payloads.offer(Map.entry(batch, --i));
                        }
                    }
                    if (!payloads.isEmpty()) {
                        Map.Entry pl = (Map.Entry)payloads.poll();
                        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)BatchedPayloads.PLAYER_STATE.payload((byte[])pl.getKey(), (Integer)pl.getValue()));
                    }
                }
            });
        }
    }

    static void onPlayerJoin(ServerPlayer player) {
        PLAYER_STATE_PAYLOADS.put(player.getUUID(), new LinkedList());
        PlayerState.initFor((Player)player);
        String trainerId = RCTMod.getInstance().getTrainerManager().registerPlayer((Player)player);
        ModCommon.RCT.getTrainerRegistry().registerPlayer(trainerId, player);
        ModCommon.LOG.info(String.format("Registered trainer player: %s", trainerId));
        ModServer.syncTrainerManger(player);
    }

    static void onPlayerQuit(ServerPlayer player) {
        String trainerId = RCTMod.getInstance().getTrainerManager().unregisterPlayer((Player)player);
        if (ModCommon.RCT.getTrainerRegistry().unregisterById(trainerId) != null) {
            ModCommon.LOG.info(String.format("Unregistered trainer player: %s", trainerId));
        }
    }

    static void onBattleVictory(BattleVictoryEvent event) {
        if (!ModServer.removeBattleFromInitiator(event.getWinners(), true)) {
            ModServer.removeBattleFromInitiator(event.getLosers(), false);
        }
    }

    static void onExperienceGained(ExperienceGainedEvent.Pre event) {
        ServerPlayer owner;
        if (!RCTMod.getInstance().getServerConfig().allowOverLeveling() && (owner = event.getPokemon().getOwnerPlayer()) != null) {
            TrainerPlayerData playerTr = RCTMod.getInstance().getTrainerManager().getData((Player)owner);
            int maxExp = event.getPokemon().getExperienceToLevel(playerTr.getLevelCap());
            if (maxExp < event.getExperience()) {
                ChatUtils.sendActionbar((Player)owner, Text.translatable((String)"gui.rctmod.actionbar.warning.level_cap"), event.getPokemon().getDisplayName(true), playerTr.getLevelCap());
            }
            event.setExperience(Math.min(event.getExperience(), maxExp));
        }
    }

    private static boolean removeBattleFromInitiator(List<BattleActor> actors, boolean winners) {
        for (BattleActor actor : actors) {
            Optional<TrainerBattle> trainerBattle = RCTMod.getInstance().getTrainerManager().getBattle(actor.getUuid());
            if (!trainerBattle.isPresent()) continue;
            RCTMod.getInstance().getTrainerManager().removeBattle(actor.getUuid());
            trainerBattle.get().distributeRewards(winners);
            return true;
        }
        return false;
    }

    record TrainerManagerPayloadTargets(byte[] bytes, int remainingBatches, Iterable<ServerPlayer> players) {
    }
}

