/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.save.collection;

import com.gitlab.srcmc.rctmod.api.data.save.collection.SavedMap;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;

public class SavedStringChunkPosMap
extends SavedMap<String, ChunkPosDim, CompoundTag> {
    public static SavedStringChunkPosMap of(CompoundTag tag, HolderLookup.Provider provider) {
        SavedStringChunkPosMap map = new SavedStringChunkPosMap();
        map.load(tag);
        return map;
    }

    public SavedStringChunkPosMap() {
        super(k -> k, t -> t, v -> SavedStringChunkPosMap.createTag(new int[]{v.pos.x, v.pos.z}, v.dim), t -> SavedStringChunkPosMap.createChunkPosDim(t), ct -> (arg_0, arg_1) -> ((CompoundTag)ct).put(arg_0, arg_1), ct -> {
            Function<String, CompoundTag> get = k -> {
                CompoundTag compoundTag;
                Tag t = ct.get(k);
                if (t instanceof IntArrayTag) {
                    IntArrayTag it = (IntArrayTag)t;
                    compoundTag = SavedStringChunkPosMap.createTag(it.getAsIntArray(), null);
                } else {
                    compoundTag = (CompoundTag)t;
                }
                return compoundTag;
            };
            return get;
        });
    }

    private static CompoundTag createTag(int[] pos, ResourceLocation dim) {
        CompoundTag t = new CompoundTag();
        t.putIntArray("pos", pos);
        t.putString("dim", dim != null ? dim.toString() : "");
        return t;
    }

    private static ChunkPosDim createChunkPosDim(CompoundTag t) {
        int[] pos = t.getIntArray("pos");
        String dim = t.getString("dim");
        return new ChunkPosDim(new ChunkPos(pos[0], pos[1]), dim.isEmpty() ? null : ResourceLocation.parse((String)dim));
    }

    public static class ChunkPosDim {
        public final ChunkPos pos;
        public final ResourceLocation dim;

        private ChunkPosDim(ChunkPos pos, ResourceLocation dim) {
            this.pos = pos;
            this.dim = dim;
        }

        public static ChunkPosDim of(Entity entity) {
            return new ChunkPosDim(entity.chunkPosition(), entity.level().dimension().location());
        }
    }
}

