/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens.widgets.controls;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class CycleButton<T>
extends AbstractButton {
    private final Component name;
    private int index;
    private T value;
    private final List<T> values;
    private final Function<T, Component> valueStringifier;
    private final Function<CycleButton<T>, MutableComponent> narrationProvider;
    private final BiConsumer<CycleButton<T>, T> onValueChange;
    private final boolean displayOnlyValue;
    private final OptionInstance.TooltipSupplier<T> tooltipSupplier;

    public static <T> CycleButton<T> create(Function<T, Component> componentFunc, List<T> values, int selected, int x, int y, int w, int h, boolean onlyValue) {
        selected = values.size() > 0 ? Mth.positiveModulo((int)selected, (int)values.size()) : -1;
        T value = values.size() > 0 ? (T)values.get(selected) : null;
        MutableComponent prefix = Component.empty();
        MutableComponent component = values.size() > 0 ? CycleButton.createLabelForValue(value, (Component)prefix, onlyValue, componentFunc) : Component.empty();
        return new CycleButton<Object>(x, y, w, h, (Component)component, (Component)prefix, selected, value, values, componentFunc, c -> (MutableComponent)c.getMessage(), (c, v) -> {}, v -> null, onlyValue);
    }

    CycleButton(int i, int j, int k, int l, Component component, Component component2, int m, T object, List<T> values, Function<T, Component> function, Function<CycleButton<T>, MutableComponent> function2, BiConsumer<CycleButton<T>, T> onValueChange, OptionInstance.TooltipSupplier<T> tooltipSupplier, boolean bl) {
        super(i, j, k, l, component);
        this.name = component2;
        this.index = m;
        this.value = object;
        this.values = values;
        this.valueStringifier = function;
        this.narrationProvider = function2;
        this.onValueChange = onValueChange;
        this.displayOnlyValue = bl;
        this.tooltipSupplier = tooltipSupplier;
        this.updateTooltip();
    }

    private void updateTooltip() {
        this.setTooltip(this.tooltipSupplier.apply(this.value));
    }

    public void onPress() {
        if (Screen.hasShiftDown()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int i) {
        List<T> list = this.values;
        this.index = Mth.positiveModulo((int)(this.index + i), (int)list.size());
        T object = list.get(this.index);
        this.updateValue(object);
        this.onValueChange.accept(this, (CycleButton)((Object)object));
    }

    private T getCycledValue(int i) {
        List<T> list = this.values;
        return list.get(Mth.positiveModulo((int)(this.index + i), (int)list.size()));
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (g > 0.0) {
            this.cycleValue(-1);
        } else if (g < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    public void setValue(T object) {
        List<T> list = this.values;
        int i = list.indexOf(object);
        if (i != -1) {
            this.index = i;
        }
        this.updateValue(object);
    }

    public boolean setValue(int i) {
        if ((i = Math.min(i, this.values.size() - 1)) >= 0) {
            this.index = i;
            this.updateValue(this.values.get(i));
            return true;
        }
        return false;
    }

    public void addValue(T object) {
        this.values.add(object);
    }

    private void updateValue(T object) {
        Component component = this.createLabelForValue(object);
        this.setMessage(component);
        this.value = object;
        this.updateTooltip();
    }

    private Component createLabelForValue(T object) {
        return this.displayOnlyValue ? this.valueStringifier.apply(object) : this.createFullName(object);
    }

    private MutableComponent createFullName(T object) {
        return CommonComponents.optionNameValue((Component)this.name, (Component)this.valueStringifier.apply(object));
    }

    private static <T> Component createLabelForValue(T object, Component name, boolean displayOnlyValue, Function<T, Component> valueStringifier) {
        return displayOnlyValue ? valueStringifier.apply(object) : CycleButton.createFullName(object, name, valueStringifier);
    }

    private static <T> MutableComponent createFullName(T object, Component name, Function<T, Component> valueStringifier) {
        return CommonComponents.optionNameValue((Component)name, (Component)valueStringifier.apply(object));
    }

    public T getValue() {
        return this.value;
    }

    public int getIndex() {
        return this.index;
    }

    protected MutableComponent createNarrationMessage() {
        return this.narrationProvider.apply(this);
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            T object = this.getCycledValue(1);
            Component component = this.createLabelForValue(object);
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{component}));
            } else {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{component}));
            }
        }
    }

    public MutableComponent createDefaultNarrationMessage() {
        return CycleButton.wrapDefaultNarrationMessage((Component)(this.displayOnlyValue ? this.createFullName(this.value) : this.getMessage()));
    }
}

